;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;! This routine belongs to the PHT-Interactive Analysis package, PIA.        !
;!                                                                           !
;! PIA was developed by the European Space Agency (ESA/ESTEC)                !
;! in collaboration with                                                     !
;!   Max-Planck-Institute for Nuclear Physics (MPIK), Heidelberg, Germany,   !
;!   Dublin Institute for Advanced Studies (DIAS), Dublin, Ireland,          !
;!   Rutherford Appleton Laboratory, (DRAL), Chilton, UK, and                !
;!   Astronomy Institute Potsdam, (AIP), Potsdam, Germany,                   !
;! with support from Max-Planck-Institute for Astronomy (MPIA), Heidelberg.  !
;!                                                                           !
;! It shall be used for scientific analysis and calibration of ISOPHOT data. !
;!                                                                           !
;! Its use and distribution are free, as long as this header text is not     !
;! removed, or changed. When publishing data reduced with this analysis      !
;! package, please mention this in the acknowledgement.                      !
;!                                                                           !
;! No warranties for installation / support/ maintenance can be given.       !
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	PRO IA_INIT_SYSV
;+
; NAME:
;	IA_INIT_SYSV
;
; PURPOSE:
;	To initialize the Interactive Analysis with the internal system
;	variables needed
;
;
; CATEGORY:
;	PIA - initialisation
;
; CALLING SEQUENCE:
;	IA_INIT_SYSV
;
; INPUTS:
;	None
;
; OUTPUTS:
;	(none)
;
; COMMON BLOCKS:
;	(none)
;
; PROCEDURE:
;	Calibration G files are used eventually together with parameters
;	which are direcly written into this routine and do not change
;	frequently.
;
; PROCEDURES USED:
;	(none)
;
; MODIFICATION HISTORY:
;	Written by:	Carlos Gabriel, ESA/VILSPA	October 1995
;       Modified by CG March 97
;       Version 6.1
;	System variables for astron coord + error bars added (CG)
;							September 1997
;	V6.5
;	!PIA_SERDIR added (CG)				April 1998
;	V7.1
;	!BIWEIGHT_C and !BIWEIGHT_S added		May 2002
;-

;
 On_ERROR,2                                          ;Return to caller

;- @splitramp_par

;
;  Define non-standard variables Textunit and Textout (e.g. necessary for FITSDIR)
;
 DEFSYSV, '!TEXTUNIT', 0
 DEFSYSV, '!TEXTOUT',1

; Define OTF flag "direction"
 DEFSYSV, '!OTFLOW', 1
; MESSAGE, /INFO, 'OTF low = 1 ----  OTF high = 0'
; MESSAGE, /INFO, 'To redefine: DEFSYSV, "!OTFLOW", 0     from prompt'

;
; Define FITDIR -- the fits data dir
;        INTDIR -- the IDL internal save file dir
;        PRINT  -- the print dir
; External logical variables: PIA_DIR, FITDIR, PIA_SAVEDIR, PIA_PRINTDIR
;	CALG, CALSAVE
;
  DEFSYSV, '!PIA_TOP', GETENV('PIA_LOC_GEN')
  DEFSYSV, '!PIA_TOP_WID', 0L
  DEFSYSV, '!FITDIR', GETENV('FITDIR')
  DEFSYSV, '!PFITDIR', GETENV('FITDIR')
  DEFSYSV, '!PIA_SERDIR',  GETENV('PIA_SERDIR')
  DEFSYSV, '!XDRDIR', GETENV('XDRDIR')
  DEFSYSV, '!CALG', GETENV('CALG')
  DEFSYSV, '!CALU', GETENV('CALU')
  DEFSYSV, '!CALC', GETENV('CALC')
  DEFSYSV, '!CALSAVE', GETENV('CALSAVE')
  DEFSYSV, '!INTDIR', GETENV('PIA_SAVEDIR')
  DEFSYSV, '!PRINT',  GETENV('PIA_PRINTDIR')
  DEFSYSV, '!PIA_PRINTDIR',  GETENV('PIA_PRINTDIR')
  DEFSYSV, '!F_ALLPERIGEE', GETENV('F_ALLPERIGEE')
  DEFSYSV, '!PIA_HTML',  GETENV('PIA_HTML')
  DEFSYSV, '!PIA_HELP',  GETENV('PIA_HELP')
  DEFSYSV, '!PIA_NVIEWS', 4
  DEFSYSV, '!NO_WEIGHTS', 0
  DEFSYSV, '!CORRCOOR', 0
  DEFSYSV, '!PIA_FFUSE', 1
  DEFSYSV, '!SUBD_RAMP', 0
  DEFSYSV, '!PIA_VERSION', ''
  bufinfo = {level:'ERD',det:'P1'}
  DEFSYSV, '!PIA_BUFINFO', bufinfo
  DEFSYSV, '!NO_ERRBARS', 0
  DEFSYSV, '!PIA_PLOT_LIMIT', [0,0]
  DEFSYSV, '!PIA_XPLOT_LIMIT', [0,0]
  DEFSYSV, '!PIA_SERDIR', GETENV('PIA_SERDIR')
  DEFSYSV, '!ISSA_DIR', GETENV('PIA_SERDIR')
  DEFSYSV, '!polycheby_maxdeg',16
  DEFSYSV, '!IRAF_LOGIN', GETENV('PIA_IRAFLOGIN')
  DEFSYSV, '!IRAF_DATA', GETENV('PIA_IRAFDATA')
  DEFSYSV, '!BIWEIGHT_C', 1
  DEFSYSV, '!BIWEIGHT_S', 0
;-  splitramp_par_init
  defsysv, '!P32TOOLS_VERSION', 'V2.0'




RETURN
END
