;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTCAP
;
; PURPOSE:
;	Definition of the common block PHTCAP for inclusion into other routines.  By defining
;	The common block PHTCAP contains information about the CRE integration
;	capacitances.
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtcap
;
; COMMON BLOCK PARAMETERS:
;	P1CAP : The P1 detector capacitance
;	P2CAP : The P2 detector capacitance
;	P3CAP : The P3 detector capacitance
;	C1CAP : The C100 capacitance
;	C2CAP : The C200 capacitance
;	SLCAP : The SL capacitance 
;	SSCAP : The SS capacitance 
;
; MODIFICATION HISTORY:
;	Wrtten by: Carlos GABRIEL(ESA/ESTEC) 	October 1994
;       Modified (last) by:  cg			April 1995
;	Oct 95 Version 3.5
;
;-

	COMMON PHTCAP, p1cap, p2cap, p3cap, c1cap, c2cap, slcap, sscap
