;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       Phtcla_init
; PURPOSE:
;       Initializes the structure PHTCLA defining the contents as
;	a template structure PHTCLA_TYPE. It can be used for clearing
;	the whole CLA structure, in case this should show as necessary. 
;
; CATEGORY:
;       PIA - initialization
;
; CALLING SEQUENCE:
;       @phtcla_init
;
; COMMON BLOCKS:
;	phtcla
;
; MODIFICATION HISTORY:
;	Wrtten by: Carlos GABRIEL(ESA/ESTEC) 	July 1994
;       Modified (last) by:  cg			September 1995
;	cla_first_handle and cla_last_handle added (WMT) May 1996
;	Oct 95 Version 3.5
;	
;-
;
@phtcla
        ON_ERROR, 2
;
	PHTCLA_REC = {PHTCLA_TYPE, UNIT: ' ', $
	DET: ' ',	$
	ADMN: ' ',	$
        ORDR: 0, 	$
        DIMS: 0L,	$ 
	HDR: HANDLE_CREATE(), $
        TIME: HANDLE_CREATE(), $
        TKEY: HANDLE_CREATE(), $ 
        RPID: HANDLE_CREATE(), $ 
        QFLG: HANDLE_CREATE(), $ 
	KYID: HANDLE_CREATE(), $ 
	FILT: HANDLE_CREATE(), $
	APER: HANDLE_CREATE(), $
	POLZ: HANDLE_CREATE(), $
        STAT: HANDLE_CREATE(), $ 
        DWEL: HANDLE_CREATE(), $ 
        CPOS: HANDLE_CREATE(), $ 
        FCS1: HANDLE_CREATE(), $ 
        FCS2: HANDLE_CREATE(), $ 
        TEMP: HANDLE_CREATE(), $
        BIAS: HANDLE_CREATE(), $
        MNSG: HANDLE_CREATE(), $
        MNSU: HANDLE_CREATE(), $
        MDSG: HANDLE_CREATE(), $
        Q1SG: HANDLE_CREATE(), $
        Q3SG: HANDLE_CREATE(), $
        PLEN: HANDLE_CREATE(), $
        FLAG: HANDLE_CREATE()}
; the first_handle is the index of the first handle in the
; structure and the last_handle is the index of the last
; handle, it is mainly used for clear the buffer. Define
; here would eliminate the need to change the cla_init
; for releasing the handle.
	CLA_FIRST_HANDLE = 5
	CLA_LAST_HANDLE  = 27
	PHTCLA = {PHTCLA_TYPE}
