;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTCRELIN
;
; PURPOSE:
;	Definition of the common block PHTCRELIN for inclusion into other
;	routines.  The common block PHTCRELIN contains the CRE linerization
;	correction for the PHT detectors.
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtcrelin
;
; COMMON BLOCK PARAMETERS:
;	PC1CRELIN : The C100 linearisation corrections
;	PC2CRELIN : The C200 linearisation corrections
;	PPCRELIN : The P1, P2, P3 linearisation corrections
;
; MODIFICATION HISTORY:
;	Wrtten by: Carlos GABRIEL, ESA/ESTEC 		March 1995
;	Oct 95 Version 3.5
;
;-

	COMMON PHTCRELIN, pc1crelin, pc2crelin, ppcrelin
