;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTDIETRANS
;
; PURPOSE:
;	Definition of the common block PHTDIETRANS (Digital Interface
;	Electronics (DIE) transfer function for inclusion into other routines.
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtdietrans
;
; COMMON BLOCK PARAMETERS:
;	PHTDIETRANS contains the following arrays (2 * 3 dimensions, 
;		    corresponding to the DIE Units 1 or 2, and to the 
;		    three possible selected gains in the order 1, 8 and 40) :
;
;	  PDIEFIX	= Fixed Offsets                      
;	  PDIEUOF	= Offsets Dependent on signal gain   
;	  PDIEGN1	= Signal Gains                       
;	  PDIEGN2	= Offset Gains                       
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL (ESA/ESTEC) 		 Jan 1994
;	Oct 95 Version 3.5
;-

	COMMON PHTDIETRANS, PDIEFIX, PDIEUOF, PDIEGN1, PDIEGN2
