;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       Phtdrift_init
;
; PURPOSE:
;       Initializes the structure PHTDRIFT defining the contents as
;	a template structure PHTDRIFT_TYPE. It can be used for clearing
;	the whole DRIFT structure, in case this should show as necessary. 
;
; CALLING SEQUENCE:
;       @phtdrift_init
;
;
; COMMON BLOCKS:
;	phtdrift
;
; MODIFICATION HISTORY:
;       Written by: C. Gabriel + J. Acosta                     October 1996
;	V5.x	
;-
;
@phtdrift
;
	PHTDRIFT_REC = {PHTDRIFT_TYPE, 	$
	  ADMN: ' ',      		$
	  PROCT:' ',			$
	  STAB: HANDLE_CREATE(), 	$
	  SLOPV: HANDLE_CREATE(), 	$
          DRIFT: HANDLE_CREATE()}
          
; the first_handle is the index of the first handle in the
; structure and the last_handle is the index of the last
; handle, it is mainly used for clear the buffer. Define
; here would eliminate the need to change the drift_init
; for releasing the handle.
        DRIFT_FIRST_HANDLE = 2
        DRIFT_LAST_HANDLE =  4
        
	PHTDRIFT_DESC = [ 			$
                'Internal Name ',               $
                'Processing date ',             $
                'Stability structure  ',        $
                'Slope variation structure',    $
                'Drift modelling struct.' 	$
		]
	PHTDRIFT = {PHTDRIFT_TYPE}
