;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	phthk
;
; PURPOSE:
;	Definition of the common block PHTHK (PHT house Keeping) for
;	inclusion into other routines.  
;
; CATEGORY:
;          PIA - common block
;
; CALLING SEQUENCE:
;	@phthk
;
;COMMON BLOCK PARAMETERS:
;	PHTCS contains the following arrays:
;
;		hkout   :converted hk data, reduced to specific measurement
;                        with get_pht_hk
;               idb     :database array,idb(1,i)contains the name of the
;                        hk with index i in hkout.
;                        For more information see the conv_hk program
;               hkdat   :pht data from the GEHK file
;               timestep:timestep, after use of get_pht_hk reduced and converted
;               hdr_idb :header of the idb-table
;
; MODIFICATION HISTORY:
;       Written by: Andreas Karch, October 1994
;	Oct 95 Version 3.5
;			
;-

common phthk,hkout,idb,hkdat,timestep,timestep_redu,hdr_idb

