;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTPOLAR
;
; PURPOSE:
;	Definition of the common block PHTPOLAR (polarizer mnemonics) for 
;	inclusion into other routines. 
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtpolar
;
;COMMON BLOCK PARAMETERS:
;	This common block contains string arrays for all PHT POLARIZERS
;
;	PHTPOLAR            
;
;  Modification History:
;	Written by: Carlos GABRIEL (ESA/VILSPA-SAI)	February 1996
;-

	COMMON PHTPOLAR, phtpolar, phtpoldeg

	phtpolar = ['0 deg', '120 deg', '240 deg', 'Flat']
	phtpoldeg = [0,120,240,-1]
