;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTPPSF
;
; PURPOSE:
;	Definition of the common block PHTPPSF Point Spread Function Factors) 
;	for inclusion into other routines. 
;
; CATEGORY:
;        PIA - common block
;
; CALLING SEQUENCE:
;	@phtppsf
;
; COMMON BLOCK PARAMETERS:
;	This file stores data about the phot apertures
;
;	  PHTPPSF : Flt Array(16,14) - Point Spread Function for 
;					PHT-P             (0-13,0-13) FIL-APER
;	                                PHT-C  PSF_ARRAY  (14  ,0-13)    -FIL 
;	                                PHT-C  PSF_PIXEL  (15  ,0-13)    -FIL 
;
; MODIFICATION HISTORY:
;	Wrtten by: Carlos GABRIEL (ESA/ESTEC-SAI) 	March 1995
;	Oct 95 Version 3.5
;	No change in the CB but in its definition (16,14) instead of (15,14)
;	V7.4    Jun 1999
;			
;-

	COMMON PHTPPSF, phtppsf
