;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTRESDEF
; PURPOSE:
;	Definition of the common block PHTRESDEF (Default Detector
;	Responsivities) for inclusion into other routines.  
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtresdef
;
; COMMON BLOCK PARAMETERS:
;	This file stores data from a PHT response file
;
;	PHTRESP contains the following variables:
;
;	P1RESP : The P1 detector response
;	P2RESP : The P2 detector response
;	P3RESP : The P3 detector response
;	C1RESP : Array: The C100 9 pixel responses
;	C2RESP : Array: The C200 4 pixel responses
;	SLRESP : Array: The S 128 pixel responses 
;	P1RESU : Uncertainty of P1RESP 
;	P2RESU : Uncertainty of P2RESP 
;	P3RESU : Uncertainty of P3RESP 
;	C1RESU : Uncertainties of C1RESP 
;	C2RESU : Uncertainties of C2RESP
;	SLRESU : Uncertainties of SLRESP
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL, ESA/ESTEC 		October 1994
;	Modified (last) by: CG				November 1994
;	Oct 95 Version 3.5
;			
;-

	COMMON PHTRESDEF, p1resp, p2resp, p3resp, c1resp, c2resp, slresp, $
                          p1resu, p2resu, p3resu, c1resu, c2resu, slresu
                          
