;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTSELNDR
;
; PURPOSE:
;	Definition of the common block PHTSELNDR (Non-destructive Read-out
;	Selection) for inclusion into other routines.  
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;
;	@phtselndr
;
; COMMON BLOCK PARAMETERS:
;	PHTSELNDR contains the following variables:
;
;	PP1SNDR: Array of NDRs skipped by P1 integration ramps per Tint 
;	PP2SNDR: Array of NDRs skipped by P2 integration ramps per Tint 
;	PP3SNDR: Array of NDRs skipped by P3 integration ramps per Tint 
;	PC1SNDR: Array of NDRs skipped by C1 integration ramps per Tint 
;	PC2SNDR: Array of NDRs skipped by C2 integration ramps per Tint 
;	PSSSNDR: Array of NDRs skipped by SS integration ramps per Tint 
;	PSSSNDR: Array of NDRs skipped by SL integration ramps per Tint 
;
; MODIFICATION HISTORY:
;	Carlos GABRIEL, ESA/ESTEC 		February 1995
;	Oct 95 Version 3.5
;
;-
	COMMON PHTSELNDR, PP1SNDR, PP2SNDR, PP3SNDR, PC1SNDR, PC2SNDR,$
			  PSSSNDR, PSLSNDR

