;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       phtsm_init
;
; PURPOSE:
;       Initializes the structure COMMON block PHTSM used for Serendipity
;	processing.
;
; CATEGORY:
;       PIA - initialization
;
; CALLING SEQUENCE:
;       @phtsm_init
;
; MODIFICATION HISTORY:
;       Written by: R. Assendorp (AIP Potsdam)		August 1996
;	Modified:
;	  smp_bckit introduced, smp_snrps deleted (SB, January 1997)
;	  point_source_type initialized (SB, February 1997)
;	  all smp_* values except smp_vel deleted (SB, December 1997)
;-
;
smp_vel = 1.5

; create point source structure

point_sources_type = { Point_Source, $
                       c_no: 0, $
                       s_no: 0, $
                       ra: 0.0d0, $
                       rau: 0.0d0, $
                       dec: 0.0d0, $
                       decu: 0.0d0, $
                       flx: 0.0d0, $
                       flxu: 0.0d0, $
                       vel: 0.0d0, $
                       cc: 0.0d0, $
                       back: dblarr(4), $
                       noise: dblarr(4), $
                       snr: dblarr(4), $
                       samp_s: 0l, $
                       samp_e: 0l, $
                       real: 0l, $
                       dist: 0.0D0, $
                       chisqr: 0.0D0 $
                     }


