;+
; NAME:
;       PhtSmc_init
; PURPOSE:
;       Initializes the structure PHTSMC defining the contents as
;	a template structure PHTSMC_TYPE. It can be used for clearing
;	the whole SMC structure, in case this should show as necessary. 
;
; CALLING SEQUENCE:
;       PHTSMC_INIT
;
; INPUT PARAMETERS:
;	None       
;
; OUTPUT PARAMETERS: 
;	None
;
; PROCEDURES USED:
;       None
;
; MODIFICATION HISTORY:
;       Written by P. Merluzzi                      	August 1995
;       Sky coordinates and roll angle                  August 1995
;       uncertainties added
;	smc_first_handle, smc_last_handle and phtsmc_desc
;	added			(WMT)			May 1996
;       MNPW/MNPU -> FLX/FLXU, ITUT removed (SB)        July 1996
;       New SMC structure (SB)				January 1997
;-
;
@phtsmc
        ON_ERROR, 2
;
	PHTSMC_REC = {PHTSMC_TYPE, UNIT: ' ', $
	DET: ' ',	$
	ADMN: ' ',	$
        ORDR: 0, 	$
        DIMS: 0L,	$
	HDR: HANDLE_CREATE(), $
        TKEY: HANDLE_CREATE(), $
	TIME: HANDLE_CREATE(), $
	FLX: HANDLE_CREATE(), $
	FLXU: HANDLE_CREATE(), $
	BACK: HANDLE_CREATE(), $
	NOIS: HANDLE_CREATE(), $
	FLAG: HANDLE_CREATE(), $
	SMFL: HANDLE_CREATE(), $
        RA: HANDLE_CREATE(), $
        RAU: HANDLE_CREATE(), $
        DEC: HANDLE_CREATE(), $
        DECU: HANDLE_CREATE(), $
        ROLL: HANDLE_CREATE(), $
        ROLU: HANDLE_CREATE()}
; the first_handle is the index of the first handle in the
; structure and the last_handle is the index of the last
; handle, it is mainly used for clear the buffer. Define
; here would eliminate the need to change the smc_init
; for releasing the handle.
	SMC_FIRST_HANDLE=5
	SMC_LAST_HANDLE=19
        PHTSMC_DESC = [ $
                'Acquisition date',                     $
                'Detector',                             $
                'Internal Name ',                       $
                'Order within TDT ',                    $
                'Dimensions    ',                       $
                'Header',                               $
                'Instrument time key    ',              $
                'Time within Measurement',              $
                'Surface brightness (MJy/sr)',		$
                'Surface brightness uncertainty',	$
                'Background (MJy/sr)',			$
                'Noise (MJy/sr)',			$
                'Status flags    ',			$
                'Serendipity flags     ',               $
                'Right Ascension of C200 center (deg.)',$
                'Right Ascension uncertainty',		$
                'Declination of C200 center (deg.)',    $
                'Declination uncertainty',		$
                'C200 Roll Angle (deg.)      ',		$
                'Roll Angle uncertainty'		$
        ]
  	PHTSMC = {PHTSMC_TYPE}
