;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       Phtspd_init
;
; PURPOSE:
;       Initializes the structure PHTSPD (Standard Processed Data) defining
;	the contents as a template structure PHTSPD_TYPE. It can be 
;	used for clearing the whole SPD structure, in case this
;	should show as necessary. 
;
; CATEGORY:
;       PIA - initialization
; COMMON BLOCKS:
;	phtspd
;
; CALLING SEQUENCE:
;       @phtspd_init
;
; MODIFICATION HISTORY:
;       Written by: C. Gabriel (ESA/ESTEC)              July 1994
;	Mdodified (last) by: CG 			October 1994
;	spd_first_handle, spd_last_handle added (WMT)   May 1996
;	phtspd_desc added (WMT)				May 1996
;	Oct 95 Version 3.5
;
;-
;
@phtspd
        ON_ERROR, 2
;
	PHTSPD_REC = {PHTSPD_TYPE, UNIT: ' ', $
	DET: ' ',	$
	ADMN: ' ',	$
        ORDR: 0, 	$
        DIMS: 0L,	$ 
	HDR: HANDLE_CREATE(), $
        TKEY: HANDLE_CREATE(), $ 
        RPID: HANDLE_CREATE(), $ 
        KYID: HANDLE_CREATE(), $ 
        FILT: HANDLE_CREATE(), $ 
        APER: HANDLE_CREATE(), $ 
        POLZ: HANDLE_CREATE(), $ 
        NDRS: HANDLE_CREATE(), $ 
        CSTP: HANDLE_CREATE(), $ 
        DWEL: HANDLE_CREATE(), $ 
        MEAS: HANDLE_CREATE(), $ 
        CPOS: HANDLE_CREATE(), $
        TIME: HANDLE_CREATE(), $
        MNPW: HANDLE_CREATE(), $
        MNPU: HANDLE_CREATE(), $
        MDPW: HANDLE_CREATE(), $
        Q1PW: HANDLE_CREATE(), $
        Q3PW: HANDLE_CREATE(), $
	DEC: HANDLE_CREATE(), $
	RA: HANDLE_CREATE(), $
	ROLL: HANDLE_CREATE(), $
	PLEN: HANDLE_CREATE(), $
	FLAG: HANDLE_CREATE()}
; the first_handle is the index of the first handle in the
; structure and the last_handle is the index of the last
; handle, it is mainly used for clear the buffer. Define
; here would eliminate the need to change the spd_init
; for releasing the handle.
	SPD_FIRST_HANDLE = 5
	SPD_LAST_HANDLE = 27
        PHTSPD_DESC = [ $
                'Acquisition date',                     $
                'Detector',                             $
                'Internal Name ',                       $
                'Order within TDT ',                    $
                'Dimensions    ',                       $
                'Header',                               $
		'Instrument time key',			$
		'Raster point id',			$
		'Key id',				$
                'Filter (CHW3)',                        $
                'Aperture (CHW2)',                      $
                'Polarizer (CHW1)',                     $
                'Nr of Destructive-Read-outs ',         $
                'Chopper step     ',                    $
                'Dwell Time ',                          $
                'Time within Meas',                     $
		'Chopper position',			$
                'Measurement Time ',                    $
                'Mean Power / Chopper Plateau',		$
                'Mean Power uncertainty',		$
                'Median Power / Chopper Plateau',	$
                'First Quartiles',                      $
                'Third Quartiles',                      $
                'Declination            ',              $
                'Right Ascension       ',               $
                'Roll Angle   ',                        $
		'Plateau length',			$
                'Flag '                                 $
        	]
	PHTSPD = {PHTSPD_TYPE}
