;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;! This routine belongs to the PHT-Interactive Analysis package, PIA.        !
;!                                                                           !
;! PIA was developed by the European Space Agency (ESA/ESTEC)                !
;! in collaboration with                                                     !
;!   Max-Planck-Institute for Nuclear Physics (MPIK), Heidelberg, Germany,   !
;!   Dublin Institute for Advanced Studies (DIAS), Dublin, Ireland,          !
;!   Rutherford Appleton Laboratory, (DRAL), Chilton, UK, and                !
;!   Astronomy Institute Potsdam, (AIP), Potsdam, Germany,                   !
;! with support from Max-Planck-Institute for Astronomy (MPIA), Heidelberg.  !
;!                                                                           !
;! It shall be used for scientific analysis and calibration of ISOPHOT data. !
;!                                                                           !
;! Its use and distribution are free, as long as this header text is not     !
;! removed, or changed. When publishing data reduced with this analysis      !
;! package, please mention this in the acknowledgement.                      !
;!                                                                           !
;! No warranties for installation / support/ maintenance can be given.       !
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PIA_XPLOT.BMD
;
; PURPOSE:
;	Definition of the bitmap PIA_XPLOT.BMD for inclusion
;	into other routines.
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@pia_xplot.bmd
;
;
; MODIFICATION HISTORY:
; 	Written by:	Stefan BOGUN (MPIA-Heidelberg)
;	Oct 95 Version 3.5
;
;-
;
; Bitmap definitions for pia_xplot.pro
;
        BM = BYTARR(6,48,7)

        BM(*,0:22,0) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 191B, 255B, 255B, 253B, 255B ],  $
                        [ 255B, 159B, 255B, 255B, 249B, 255B ],  $
                        [ 255B, 175B, 255B, 255B, 245B, 255B ],  $
                        [ 255B, 183B, 255B, 255B, 237B, 255B ],  $
                        [ 255B,  59B, 192B,   3B, 220B, 255B ],  $
                        [ 255B, 253B, 223B, 251B, 191B, 255B ],  $
                        [ 255B, 254B, 223B, 251B, 127B, 255B ],  $
                        [ 127B, 255B, 223B, 251B, 255B, 254B ] ]
       BM(*,23:47,0) =[ [ 191B, 255B, 223B, 251B, 255B, 253B ],  $
                        [ 159B, 255B, 223B, 251B, 255B, 249B ],  $
                        [  31B, 255B, 223B, 251B, 255B, 248B ],  $
                        [  63B, 254B, 223B, 251B, 127B, 252B ],  $
                        [ 127B, 252B, 223B, 251B,  63B, 254B ],  $
                        [ 255B,  56B, 192B,   3B,  28B, 255B ],  $
                        [ 255B,  49B, 240B,  15B, 140B, 255B ],  $
                        [ 255B, 163B, 255B, 255B, 197B, 255B ],  $
                        [ 255B, 135B, 255B, 255B, 225B, 255B ],  $
                        [ 255B, 143B, 255B, 255B, 241B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]

        BM(*,0:22,1) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 239B, 255B, 255B, 247B, 255B ],  $
                        [ 255B, 207B, 255B, 255B, 243B, 255B ],  $
                        [ 255B, 175B, 255B, 255B, 245B, 255B ],  $
                        [ 255B, 111B, 255B, 255B, 246B, 255B ],  $
                        [  31B, 224B, 254B, 127B,   7B, 248B ],  $
                        [ 223B, 255B, 253B, 191B, 255B, 251B ],  $
                        [ 223B, 255B, 251B, 223B, 255B, 251B ],  $
                        [ 223B, 255B, 247B, 239B, 255B, 251B ] ]
       BM(*,23:47,1) =[ [ 223B, 255B, 239B, 247B, 255B, 251B ],  $
                        [ 223B, 255B, 207B, 243B, 255B, 251B ],  $
                        [ 223B, 255B, 199B, 227B, 255B, 251B ],  $
                        [ 223B, 255B, 227B, 199B, 255B, 251B ],  $
                        [ 223B, 255B, 241B, 143B, 255B, 251B ],  $
                        [  31B, 224B, 248B,  31B,   7B, 248B ],  $
                        [ 127B,  96B, 252B,  63B,   6B, 254B ],  $
                        [ 255B,  47B, 254B, 127B, 244B, 255B ],  $
                        [ 255B,  15B, 255B, 255B, 240B, 255B ],  $
                        [ 255B, 143B, 255B, 255B, 241B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]

        BM(*,0:22,2) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 239B, 255B,   3B,   0B, 248B ],  $
                        [ 255B, 207B, 255B, 251B, 255B, 243B ],  $
                        [ 255B, 175B, 255B, 251B, 255B, 243B ],  $
                        [ 255B, 111B, 255B, 251B, 255B, 243B ],  $
                        [  31B, 224B, 254B, 251B, 255B, 243B ],  $
                        [ 223B, 255B, 253B, 251B, 255B, 243B ],  $
                        [ 223B, 255B, 251B, 251B, 255B, 243B ],  $
                        [ 223B, 255B, 247B, 251B, 255B, 243B ] ]
       BM(*,23:47,2) =[ [ 223B, 255B, 239B, 251B, 255B, 243B ],  $
                        [ 223B, 255B, 207B, 251B, 255B, 243B ],  $
                        [ 223B, 255B, 199B, 251B, 255B, 243B ],  $
                        [ 223B, 255B, 227B, 251B, 255B, 243B ],  $
                        [ 223B, 255B, 241B, 251B, 255B, 243B ],  $
                        [  31B, 224B, 248B, 251B, 255B, 243B ],  $
                        [ 127B,  96B, 252B, 251B, 255B, 243B ],  $
                        [ 255B,  47B, 254B, 251B, 255B, 243B ],  $
                        [ 255B,  15B, 255B,   3B,   0B, 240B ],  $
                        [ 255B, 143B, 255B,   7B,   0B, 240B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]

        BM(*,0:22,3) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 252B, 255B, 255B ],  $
                        [ 255B, 255B, 127B, 248B, 255B, 255B ],  $
                        [ 255B, 255B, 191B, 241B, 255B, 255B ],  $
                        [ 255B, 255B, 223B, 227B, 255B, 255B ],  $
                        [ 255B, 255B, 239B, 199B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 143B, 255B, 255B ],  $
                        [ 255B, 255B, 251B,  31B, 255B, 255B ],  $
                        [ 255B, 255B, 253B,  63B, 254B, 255B ],  $
                        [ 255B, 255B, 254B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 240B,  15B, 254B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 239B, 255B, 255B ],  $
                        [ 255B, 255B,   7B, 224B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]
       BM(*,23:47,3) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B,   7B, 224B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 239B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 127B, 240B,  15B, 254B, 255B ],  $
                        [ 255B, 255B, 254B, 127B, 254B, 255B ],  $
                        [ 255B, 255B, 253B,  63B, 254B, 255B ],  $
                        [ 255B, 255B, 251B,  31B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 143B, 255B, 255B ],  $
                        [ 255B, 255B, 239B, 199B, 255B, 255B ],  $
                        [ 255B, 255B, 223B, 227B, 255B, 255B ],  $
                        [ 255B, 255B, 191B, 241B, 255B, 255B ],  $
                        [ 255B, 255B, 127B, 248B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 252B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]

        BM(*,0:22,4) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B,   7B, 224B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 239B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 127B, 240B,  15B, 254B, 255B ],  $
                        [ 255B, 255B, 254B, 127B, 254B, 255B ],  $
                        [ 255B, 255B, 253B,  63B, 254B, 255B ],  $
                        [ 255B, 255B, 251B,  31B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 143B, 255B, 255B ],  $
                        [ 255B, 255B, 239B, 199B, 255B, 255B ],  $
                        [ 255B, 255B, 223B, 227B, 255B, 255B ],  $
                        [ 255B, 255B, 191B, 241B, 255B, 255B ],  $
                        [ 255B, 255B, 127B, 248B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 252B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]
       BM(*,23:47,4) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 252B, 255B, 255B ],  $
                        [ 255B, 255B, 127B, 248B, 255B, 255B ],  $
                        [ 255B, 255B, 191B, 241B, 255B, 255B ],  $
                        [ 255B, 255B, 223B, 227B, 255B, 255B ],  $
                        [ 255B, 255B, 239B, 199B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 143B, 255B, 255B ],  $
                        [ 255B, 255B, 251B,  31B, 255B, 255B ],  $
                        [ 255B, 255B, 253B,  63B, 254B, 255B ],  $
                        [ 255B, 255B, 254B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 240B,  15B, 254B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 239B, 255B, 255B ],  $
                        [ 255B, 255B,   7B, 224B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]
                   
        BM(*,0:22,5) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B,   7B, 224B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 239B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 207B, 255B, 255B ],  $
                        [ 255B, 127B, 240B,  15B, 254B, 255B ],  $
                        [ 255B, 255B, 254B, 127B, 254B, 255B ],  $
                        [ 255B, 255B, 253B,  63B, 254B, 255B ],  $
                        [ 255B, 255B, 251B,  31B, 255B, 255B ],  $
                        [ 255B, 255B, 247B, 143B, 255B, 255B ],  $
                        [ 255B, 255B, 239B, 199B, 255B, 255B ],  $
                        [ 255B, 255B, 223B, 227B, 255B, 255B ],  $
                        [ 255B, 255B, 191B, 241B, 255B, 255B ],  $
                        [ 255B, 255B, 127B, 248B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 252B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]
       BM(*,23:47,5) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 127B,   0B,   0B, 255B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B, 255B, 127B, 254B, 255B ],  $
                        [ 255B, 127B,   0B,   0B, 254B, 255B ],  $
                        [ 255B, 255B,   0B,   0B, 254B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]

        BM(*,0:22,6) =[ [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 191B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 191B, 255B, 255B ],  $
                        [ 255B, 255B, 255B,  63B, 252B, 255B ],  $
                        [ 255B, 255B, 255B,  57B, 255B, 255B ],  $
                        [ 255B, 255B, 255B,  25B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 119B, 254B, 255B ],  $
                        [ 255B, 255B, 255B, 115B, 250B, 255B ],  $
                        [ 255B, 255B, 255B, 113B, 248B, 255B ],  $
                        [ 255B, 255B,  63B, 247B, 252B, 255B ],  $
                        [ 255B, 255B,  63B, 231B, 254B, 255B ],  $
                        [ 255B, 255B, 111B, 134B, 255B, 255B ],  $
                        [ 255B,  31B, 103B, 206B, 255B, 255B ],  $
                        [ 255B,  15B,  96B, 250B, 255B, 255B ],  $
                        [ 255B, 103B, 236B, 248B, 255B, 255B ],  $
                        [ 255B, 247B,  76B, 252B, 255B, 255B ] ]
       BM(*,23:47,6) =[ [ 255B, 243B,   8B, 255B, 255B, 255B ],  $
                        [ 255B, 227B, 217B, 255B, 255B, 255B ],  $
                        [ 255B,  99B, 248B, 255B, 254B, 255B ],  $
                        [ 255B,  39B, 240B, 127B, 254B, 255B ],  $
                        [ 255B, 135B, 240B, 127B, 254B, 255B ],  $
                        [ 255B,  15B, 251B, 127B, 254B, 255B ],  $
                        [ 255B, 159B, 251B, 127B, 254B, 255B ],  $
                        [ 255B, 223B, 252B,  63B, 255B, 255B ],  $
                        [ 255B,  31B, 254B,  63B, 255B, 255B ],  $
                        [ 255B, 255B, 255B,  55B, 255B, 255B ],  $
                        [ 255B, 255B, 255B,  51B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 131B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 135B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 143B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 143B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ],  $
                        [ 255B, 255B, 255B, 255B, 255B, 255B ] ]


