;+
; NAME:
;	AUX_FUNCT_TIMELINE
;
; PURPOSE:
;	different auxiliary functions for time conversions 
;
; COMMENT:
;	yes, it should be better documented.
;-

function decode_time,time
; return the decode time in hours
i=strpos(time,':')
hh=float(strmid(time,i-2,2))
mm=float(strmid(time,i+1,2))
ss=float(strmid(time,i+4,2))

return, hh+mm/60.+ss/3600.

end

function nm2mm, month
;return the month number given the name 

case strupcase(month) of 

  'JAN' : n_month=1
  'FEB' : n_month=2
  'MAR' : n_month=3
  'APR' : n_month=4
  'MAY' : n_month=5
  'JUN' : n_month=6
  'JUL' : n_month=7
  'AUG' : n_month=8
  'SEP' : n_month=9
  'OCT' : n_month=10
  'NOV' : n_month=11
  'DEC' : n_month=12

  else  : print,'Not a valid month name'
endcase

return,n_month

end

function mm2nm, nmonth
;return the month name given the number

case nmonth of 

  1     : month = 'JAN' 
  2     : month = 'FEB' 
  3     : month = 'MAR' 
  4     : month = 'APR' 
  5     : month = 'MAY' 
  6     : month = 'JUN' 
  7     : month = 'JUL' 
  8     : month = 'AUG' 
  9     : month = 'SEP' 
  10    : month = 'OCT' 
  11    : month = 'NOV' 
  12    : month = 'DEC' 

  else  : print,'Not a valid month number'
endcase

return,month

end


function timekey, hour, min, sec, day, month, year
; this function returns the string timekey YYDDDHHMMSS
; input are read as integer or float

if n_params() ne 6 then begin
  print,'Syntax: timekey (hour, min, sec, day, month, year)'
  print,'        All inputs are strings. Give the number of the month'
  print, ' ' 
  return,-1
endif

mo=fix(month)
yr=fix(year)
da=fix(day)

; subtract to julian day the julian date of first January of same year
ddd_ov_yr=julday(mo,da,yr)-julday(1,1,yr) + 1 

;print,mo,da,yr,ddd_ov_yr


tkey=strmid(strtrim(yr,2),2,2)+string(ddd_ov_yr,format='(i3.3)')+$
      string(hour,format='(i2.2)')+ $
      string(min,format='(i2.2)') +  $
      string(sec,format='(i2.2)')


return, tkey

end

function tk2absd, timekey
; convert time key to absolute time in rational juldays
; input parameters:
;   timekey [string] <yydddhhmmss>
; output parameter:
;   absdays [double]

yr = fix('19'+strmid(timekey,0,2))
day_jul = fix(strmid(timekey,2,3)) + julday(1,1,yr) - 1 
hh = fix(strmid(timekey,5,2))
mm = fix(strmid(timekey,7,2))
sec = float(strmid(timekey,9,2))

return, double(day_jul) + (hh-12+mm/60.+sec/3600.)/24.

end


pro tk2cald, timekey, yr, mo, day

caldat, tk2absd(timekey), mo, dd, yr

day= dd+fix(strmid(timekey,5,2))/24.+fix(strmid(timekey,7,2))/24./60. + $
          fix(strmid(timekey,9,2))/24./3600.
return
end


function absd2tk, absday
; convert rational juldays to tk
 dabsday= double(absday)+0.5
 ;print,format='("dabsday=",d10.2)',dabsday
 i_days = long(dabsday)
 abs_hh = (dabsday - double(i_days)) * 24.
 caldat, dabsday, mo, dd, yr
 ;print, i_days,dabsday
 ;print, abs_hh
 hh = fix(abs_hh+1.d-7)
 abs_min = double((abs_hh - hh)*60.)
 mm = fix(abs_min+1.d-7)
 ss = float((abs_min - mm)*60.)
 tk = timekey(hh,mm,ss,dd,mo,yr)
 return, tk
end
 


function radec_str,ra_dec,dec,precision
  On_error,2

  Npar = N_params()

  case N_elements(ra_dec) of 

     1: if ( Npar EQ 1 ) then dec = ra_dec else ra = ra_dec
     2: begin
        ra = ra_dec(0) mod 360.
        if (Npar GT 1) then begin 
             precision = dec & Npar=3 & endif
        dec = ra_dec(1)
        end
   else: message, $
          'First parameter must be a scalar or 2 element ([RA,DEC]) vector'

   endcase

  if ( Npar GE 2 ) then $
	if N_elements(dec) NE 1 then message, $
      'ERROR - Declination (second parameter) must be a numeric scalar'

  if N_elements(ra) EQ 1 then begin

     if ( dec(0) LT -90. ) or ( dec(0) GT 90. ) then message, $
       'WARNING - Illegal declination value of '+strtrim(dec,2)+' degrees',/INF
     radec, ra(0), dec(0), ihr, imin, xsec, ideg, imn, xsc
     if (Npar LT 3) then precision = 1
     precision = precision > 0 < 4         ;No more than 4 decimal places
     isec = fix(xsec+0.5/10^precision)
      fsec = fix((xsec+0.5/10^precision-isec)*10^precision)
     ;print,'xsec=',xsec
     secfmt = "(I2.2," + "'.'," +  "I" + string(precision,'(I1)') + "." + $
                         string(   precision,'(I1)') + ")"
     if (Npar LT 3) then precision = 1
     result = "'" + string([ihr,imin],"(2(I2.2,':'))") $ 
        + string(isec,fsec,secfmt)  + "', '"  

  endif else begin

     x = sixty(dec)
     precision = 1
     ideg = fix(x(0)) & imn = fix(x(1)) & xsc = x(2)
     result = ''

  endelse

   if ( precision EQ 0 ) then begin 
           secfmt = '(I2.2)' 
           xsc = nint(xsc)
           if xsc EQ 60 then begin
                  xsc = 0
                  imn = imn + 1
           endif

   endif else begin

         secfmt = "(I2.2," + "'.'," +  "I" + string(precision,'(I1)') + "." + $
                         string(   precision,'(I1)') + ")"
     if fix( xsc + 0.5/10^precision ) GE 60  then begin   ;Appropriate roundoff
         xsc = 0.
         imn = imn + 1
     endif
 
  endelse

   if imn EQ 60 then begin
       if dec GT 0 then ideg = ideg + 1 else ideg = ideg -1
       imn = 0
   endif

   if ( ideg EQ 0 ) and ( min([imn,xsc]) LT 0. ) then begin
         deg = '-00' 
         imn = abs(imn) & xsc = abs(xsc)
   endif else deg =  string(ideg,'(I3.2)')

   if dec(0) GT 0 then strput, deg, '+', 0

   ;print,'xsc=',xsc 
   isc = fix(xsc+0.5/10^precision)   
    fsc = fix((xsc+0.5/10^precision-isc)*10^precision)
   
   return, result + deg + string(imn,"(':',I2.2,':')")   $
        + string(isc,fsc,secfmt) + "'" 
   

   end

