;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	CHOP_PARAM
;
; PURPOSE:
;	This is not an IDL routine as such, but contains the definition of the
;	common block CHOP_INFO for inclusion into other routines.  By defining
;	the common block in one place, the problem of conflicting definitions
;	is avoided.
;
;	This file is included into routines that need this common block with
;	the single line (left justified)
;
;				  @chop_param
;
;
;	This common block contains the Chopper Position Conversion Parameters:
;	
;	A : Coefficients for the
;	B : line approximation
;
;	C : Parameters for initial conversion
;	P : of TMDATA word to a voltage
;	Q
;	R
;
;	Ang_Dev : Line deviation tables
;	DU_DC
;
;	Norm_Ang : Correction tables
;	DU_ACD
;	DU_ACI
;
;	DCF1 : Parameters for FCS
;	DCF2
;	OF1
;	OF2
;	ACF1
;
; CATEGORY:
;	PIA - common block
;
; MODIFICATION HISTORY:
;	Written by:	Huw Morris
;	Oct 95 Version 3.5
;
;-

	COMMON Chop_param, A, B, C, P, Q, R, Ang_Dev, DU_DC, Norm_Ang, $
	       DU_ACD, DU_ACI, DCF1, DCF2, OF1, OF2, ACF1
