;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	PRO ibcksub_Param_Init
;+
; NAME:
;	IBCKSUB_PARAM_INIT
;
; PURPOSE:
;	Initialise the ibcksub_param common block
;
; CATEGORY:
;	PIA - initialisation
;
; CALLING SEQUENCE
;	IBCKSUB_PARAM_INIT
;
; INPUTS:
;	None
;
; OUTPUTS:
; 	None
;
; COMMON BLOCKS:
;	ibcksub_params
;
; SIDE EFFECTS:
;	The values of the ibcksub_params common block are initialised
;
; PROCEDURES USED:
; 	None
;
; MODIFICATION HISTORY:
;	Written by:	Jacosta					April 1998
;	V7.1
;-

@ibcksub_param

	use_median = 1
	srcstep = 98
	bckstep = 99
		
	ibcksub_params = {use_median:use_median,srcstep:srcstep, bckstep:bckstep}

	END
