;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       phtaap_init
; PURPOSE:
;       Initializes the structure PHTAAP defining the contents as
;	a template structure PHTAAP_TYPE. 
;
; CATEGORY:
;          PIA - initialization
;
; CALLING SEQUENCE:
;       PHTAAP_INIT
;
; COMMON BLOCKS:
;	phtaap
;
; MODIFICATION HISTORY:
;       Written by C. Gabriel (ESA/ESTEC-SAI)		March 1995
;	phtaap_desc added  (WMT)			May 1996
;	aap_first_handle, aap_last_handle added		May 1996
;	Central wavelength added (WMT)	 		Nov 1996
;-

@phtaap
        ON_ERROR, 2
;
	PHTAAP_REC = {PHTAAP_TYPE, $
	ADMN:' ', DET:' ', DIMS: 0L, $
	FILT: 0, APER: 0, POLZ: 0, CWVL: 0.0, $
        HDR: HANDLE_CREATE(), $
        TIME: HANDLE_CREATE(), $
        CSTP: HANDLE_CREATE(), $
        CPOS: HANDLE_CREATE(), $
        DWEL: HANDLE_CREATE(), $
        MNFL: HANDLE_CREATE(), $
        MNFU: HANDLE_CREATE(), $
        MNBR: HANDLE_CREATE(), $
        MNBU: HANDLE_CREATE(), $
        MDFL: HANDLE_CREATE(), $
        Q1FL: HANDLE_CREATE(), $
        Q3FL: HANDLE_CREATE(), $
        MDBR: HANDLE_CREATE(), $
        Q1BR: HANDLE_CREATE(), $
        Q3BR: HANDLE_CREATE(), $
        RPID: HANDLE_CREATE(), $
	DEC: HANDLE_CREATE(), $
	RA: HANDLE_CREATE(), $
	ROLL: HANDLE_CREATE(), $
	FLAG: HANDLE_CREATE()}
; the first_handle is the index of the first handle in the
; structure and the last_handle is the index of the last
; handle, it is mainly used for clear the buffer. Define
; here would eliminate the need to change the aap_init
; for releasing the handle.
	AAP_FIRST_HANDLE = 7
	AAP_LAST_HANDLE = 26
	PHTAAP = {PHTAAP_TYPE}

; the description of the phtaap structure

	phtaap_desc = [ $
		'Detector',		$
		'Internal Name',	$
		'Dimensions',		$
		'Filter (CHW3)',	$
		'Aperture (CHW2)', 	$
		'Polarizer (CHW1)', 	$
		'Central Wavelength',  	$
		'Header',		$
		'Time within Meas',	$
		'Chopper step number',  $
		'Chopper position',	$
		'Chopper dwell time',   $
		'Mean Flux',		$
		'Mean Uncertainty Flux',$
		'Mean Brightness',	$
		'Mean Uncertainty Brightness',$
		'Median Flux',		$
		'First Quartile Flux',	$
		'Third Quartile Flux',	$
		'Median Brightness',	$
		'First Quartile Brightness',	$
		'Third Quartile Birghtness',	$
		'Raster point ID',	$
		'Declination',		$
		'Right Ascension',	$
		'Roll angle',		$
		'Status flag' 		$
		]
