;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.!
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             !
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             !
 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       PHTAAR_INIT
;
; PURPOSE:
;       Definition of the PHTAAR structure for inclusion into other routines.
;
; CATEGORY:
;       PIA - initialization
;
; CALLING SEQUENCE:
;       @phtaar_init
;
; PROCEDURE:
;
; MODIFICATION HISTORY:
;       Written by: Wai-Ming Tai (DIAS)           Apr, 1996
;
;-

@phtaar
	ON_ERROR, 2
;
; PPAP PHT-P point source photometry structure
;

   PPAP_BUF = { PPAP_TYPE, $
		FILT: 0L, $
		APER: 0L, $
		NBCK: 0L, $
		SRCE: 0.0, $
		SRCU: 0.0, $
		BACK: 0.0, $
		BCKU: 0.0, $	
		SPB:  0.0, $
		SPBU: 0.0, $
		BCK1: 0.0, $
		BK1U: 0.0, $
		BCK2: 0.0, $
		BK2U: 0.0, $
		BINT: 0.0, $
		BINU: 0.0, $
		NCYC: 0L, $
		CWVL: 0.0 $
		}

; this is used for reading the fits file
   FITS_PPAP_BUF = { FITS_PPAP_TYPE, $
		FILT: 0L, $
		APER: 0L, $
		NBCK: 0L, $
		SRCE: 0.0, $
		SRCU: 0.0, $
		BACK: 0.0, $
		BCKU: 0.0, $	
		SPB:  0.0, $
		SPBU: 0.0, $
		BCK1: 0.0, $
		BK1U: 0.0, $
		BCK2: 0.0, $
		BK2U: 0.0, $
		BINT: 0.0, $
		BINU: 0.0, $
		NCYC: 0L  $
		}
;
; PPAE PHT-P extended source photometry structure
;

   PPAE_BUF = { PPAE_TYPE, $
		FILT: 0L, $
		APER: 0L, $
		NBCK: 0L, $
		SRCE: 0.0, $
		SRCU: 0.0, $
		BACK: 0.0, $
		BCKU: 0.0, $	
		SPB:  0.0, $
		SPBU: 0.0, $
		BCK1: 0.0, $
		BK1U: 0.0, $
		BCK2: 0.0, $
		BK2U: 0.0, $
		NCYC: 0L, $
		CWVL: 0.0   $
		}
; this is used for reading the fits file
   FITS_PPAE_BUF = { FITS_PPAE_TYPE, $
		FILT: 0L, $
		APER: 0L, $
		NBCK: 0L, $
		SRCE: 0.0, $
		SRCU: 0.0, $
		BACK: 0.0, $
		BCKU: 0.0, $	
		SPB:  0.0, $
		SPBU: 0.0, $
		BCK1: 0.0, $
		BK1U: 0.0, $
		BCK2: 0.0, $
		BK2U: 0.0, $
		NCYC: 0L  $
		}
;
; PPAS PHT-P scan & slew photometry structure
;

   PPAS_BUF = { PPAS_TYPE, $
		FILT: 0L, $
		RA:  0.0, $
		RAU: 0.0, $
		DEC: 0.0, $
		DECU: 0.0, $
		ROLL: 0.0, $
		ROLU: 0.0, $
		BRGT: 0.0, $
		BRGU: 0.0, $
		STAT: 0B, $
		FILL: bytarr(3)  $
		}
;
; PLAP PHT-SL point source spectroscopy structure
;

   PLAP_BUF = { PLAP_TYPE, $
		DFLG: 0L, $
		NBCK: 0L, $ 
		SRCE: fltarr(64), $
		SRCU: fltarr(64), $
		BCK:  fltarr(64), $
		BCKU:  fltarr(64), $
		SPB:  fltarr(64), $
		SPBU:  fltarr(64), $
		BCK1:  fltarr(64), $
		BK1U:  fltarr(64), $
		BCK2:  fltarr(64), $
		BK2U:  fltarr(64),  $
		LAMBDA: dblarr(64) $
		}

; this is used for reading the fits file
   FITS_PLAP_BUF = { FITS_PLAP_TYPE, $
		DFLG: 0L, $
		NBCK: 0L, $ 
		SRCE: fltarr(64), $
		SRCU: fltarr(64), $
		BCK:  fltarr(64), $
		BCKU:  fltarr(64), $
		SPB:  fltarr(64), $
		SPBU:  fltarr(64), $
		BCK1:  fltarr(64), $
		BK1U:  fltarr(64), $
		BCK2:  fltarr(64), $
		BK2U:  fltarr(64)  $
		}
;
; PLAE PHT-SL extended source spectroscopy structure
;

   PLAE_BUF = { PLAE_TYPE, $
		DFLG: 0L, $
		NBCK: 0L, $ 
		SRCE: fltarr(64), $
		SRCU: fltarr(64), $
		BCK:  fltarr(64), $
		BCKU:  fltarr(64), $
		SPB:  fltarr(64), $
		SPBU:  fltarr(64), $
		BCK1:  fltarr(64), $
		BK1U:  fltarr(64), $
		BCK2:  fltarr(64), $
		BK2U:  fltarr(64),  $
		LAMBDA: dblarr(64) $
		}
; this is used for reading the fits file
   FITS_PLAE_BUF = { FITS_PLAE_TYPE, $
		DFLG: 0L, $
		NBCK: 0L, $ 
		SRCE: fltarr(64), $
		SRCU: fltarr(64), $
		BCK:  fltarr(64), $
		BCKU:  fltarr(64), $
		SPB:  fltarr(64), $
		SPBU:  fltarr(64), $
		BCK1:  fltarr(64), $
		BK1U:  fltarr(64), $
		BCK2:  fltarr(64), $
		BK2U:  fltarr(64)  $
		}
;
; PLAS PHT-SL Raster mode spectroscopy structure
;

   PLAS_BUF = { PLAS_TYPE, $
		DFLG: 0L, $
		RA: 0.0, $
		RAU: 0.0, $
		DEC: 0.0, $
		DECU: 0.0, $
		ROLL: 0.0, $
		ROLU: 0.0, $
		SPB: fltarr(64), $
		SPBU: fltarr(64),  $
		LAMBDA: dblarr(64) $
		}
; this is used for reading the fits file
   FITS_PLAS_BUF = { FITS_PLAS_TYPE, $
		DFLG: 0L, $
		RA: 0.0, $
		RAU: 0.0, $
		DEC: 0.0, $
		DECU: 0.0, $
		ROLL: 0.0, $
		ROLU: 0.0, $
		SPB: fltarr(64), $
		SPBU: fltarr(64)  $
		}
;
; PSAP PHT-SS point source spectroscopy structure
;

   PSAP_BUF = { PSAP_TYPE, $
		DFLG: 0L, $
		NBCK: 0L, $ 
		SRCE: fltarr(64), $
		SRCU: fltarr(64), $
		BCK:  fltarr(64), $
		BCKU:  fltarr(64), $
		SPB:  fltarr(64), $
		SPBU:  fltarr(64), $
		BCK1:  fltarr(64), $
		BK1U:  fltarr(64), $
		BCK2:  fltarr(64), $
		BK2U:  fltarr(64),  $
		LAMBDA: dblarr(64) $
		}
; this is used for reading the fits file
   FITS_PSAP_BUF = { FITS_PSAP_TYPE, $
		DFLG: 0L, $
		NBCK: 0L, $ 
		SRCE: fltarr(64), $
		SRCU: fltarr(64), $
		BCK:  fltarr(64), $
		BCKU:  fltarr(64), $
		SPB:  fltarr(64), $
		SPBU:  fltarr(64), $
		BCK1:  fltarr(64), $
		BK1U:  fltarr(64), $
		BCK2:  fltarr(64), $
		BK2U:  fltarr(64)  $
		}
;
; PSAE PHT-SS extended source spectroscopy structure
;

   PSAE_BUF = { PSAE_TYPE, $
		DFLG: 0L, $
		NBCK: 0L, $ 
		SRCE: fltarr(64), $
		SRCU: fltarr(64), $
		BCK:  fltarr(64), $
		BCKU:  fltarr(64), $
		SPB:  fltarr(64), $
		SPBU:  fltarr(64), $
		BCK1:  fltarr(64), $
		BK1U:  fltarr(64), $
		BCK2:  fltarr(64), $
		BK2U:  fltarr(64),  $
		LAMBDA: dblarr(64) $
		}
; this is used for reading the fits file
   FITS_PSAE_BUF = { FITS_PSAE_TYPE, $
		DFLG: 0L, $
		NBCK: 0L, $ 
		SRCE: fltarr(64), $
		SRCU: fltarr(64), $
		BCK:  fltarr(64), $
		BCKU:  fltarr(64), $
		SPB:  fltarr(64), $
		SPBU:  fltarr(64), $
		BCK1:  fltarr(64), $
		BK1U:  fltarr(64), $
		BCK2:  fltarr(64), $
		BK2U:  fltarr(64)  $
		}
;
; PSAS PHT-SS Raster mode spectroscopy structure
;

   PSAS_BUF = { PSAS_TYPE, $
		DFLG: 0L, $
		RA: 0.0, $
		RAU: 0.0, $
		DEC: 0.0, $
		DECU: 0.0, $
		ROLL: 0.0, $
		ROLU: 0.0, $
		SPB: fltarr(64), $
		SPBU: fltarr(64),  $
		LAMBDA: dblarr(64) $
		}
; this is used for reading the fits file
   FITS_PSAS_BUF = { FITS_PSAS_TYPE, $
		DFLG: 0L, $
		RA: 0.0, $
		RAU: 0.0, $
		DEC: 0.0, $
		DECU: 0.0, $
		ROLL: 0.0, $
		ROLU: 0.0, $
		SPB: fltarr(64), $
		SPBU: fltarr(64)  $
		}
;
; PCAP PHT-C point source photometry structure
;

   PCAP_BUF = { PCAP_TYPE, $
		FILT: 0L, $
		NBCK: 0L, $
		NPIX: 0L, $
		SRCE: fltarr(9), $
		SRCU: fltarr(9), $
		SPB: fltarr(9), $
		SPBU: fltarr(9), $
		B1: fltarr(9), $
		B1U: fltarr(9), $
		B2: fltarr(9), $
		B2U: fltarr(9), $
		PEAK: 0.0, $
		PKU: 0.0, $
		BCKS: 0.0, $
		BKSU: 0.0, $
		BCK1: 0.0, $
		BK1U: 0.0, $
		BCK2: 0.0, $
		BK2U: 0.0, $
		BINS: 0.0, $
		BISU: 0.0, $
		BIN1: 0.0, $
		BI1U: 0.0, $
		BIN2: 0.0, $
		BI2U: 0.0, $
		OFF:  fltarr(2), $
		OFFU: fltarr(2), $
		FITU: 0.0, $
		STAT: 0.0, $
		NCYC: fltarr(9), $
		CWVL: 0.0   $
		}
; this is used for reading the fits file
   FITS_PCAP_BUF = { FITS_PCAP_TYPE, $
		FILT: 0L, $
		NBCK: 0L, $
		NPIX: 0L, $
		SRCE: fltarr(9), $
		SRCU: fltarr(9), $
		SPB: fltarr(9), $
		SPBU: fltarr(9), $
		B1: fltarr(9), $
		B1U: fltarr(9), $
		B2: fltarr(9), $
		B2U: fltarr(9), $
		PEAK: 0.0, $
		PKU: 0.0, $
		BCKS: 0.0, $
		BKSU: 0.0, $
		BCK1: 0.0, $
		BK1U: 0.0, $
		BCK2: 0.0, $
		BK2U: 0.0, $
		BINS: 0.0, $
		BISU: 0.0, $
		BIN1: 0.0, $
		BI1U: 0.0, $
		BIN2: 0.0, $
		BI2U: 0.0, $
		OFF:  fltarr(2), $
		OFFU: fltarr(2), $
		FITU: 0.0, $
		STAT: 0.0, $
		NCYC: fltarr(9) $
		}
;
; PCAE PHT-C extended source photometry structure
;

   PCAE_BUF = { PCAE_TYPE, $
		FILT: 0L, $
		NBCK: 0L, $
		NPIX: 0L, $
		SRCE: fltarr(9), $
		SRCU: fltarr(9), $
		SPB: fltarr(9), $
		SPBU: fltarr(9), $
		B1: fltarr(9), $
		B1U: fltarr(9), $
		B2: fltarr(9), $
		B2U: fltarr(9), $
		BACK: 0.0, $
		BCKU: 0.0, $
		BCK1: 0.0, $
		BK1U: 0.0, $
		BCK2: 0.0, $
		BK2U: 0.0, $
		NCYC: fltarr(9), $
		CWVL: 0.0   $
		}
; this is used for reading the fits file
   FITS_PCAE_BUF = { FITS_PCAE_TYPE, $
		FILT: 0L, $
		NBCK: 0L, $
		NPIX: 0L, $
		SRCE: fltarr(9), $
		SRCU: fltarr(9), $
		SPB: fltarr(9), $
		SPBU: fltarr(9), $
		B1: fltarr(9), $
		B1U: fltarr(9), $
		B2: fltarr(9), $
		B2U: fltarr(9), $
		BACK: 0.0, $
		BCKU: 0.0, $
		BCK1: 0.0, $
		BK1U: 0.0, $
		BCK2: 0.0, $
		BK2U: 0.0, $
		NCYC: fltarr(9) $
		}
;
; PCAS PHT-C scan & slew photometry structure
;

   PCAS_BUF = { PCAS_TYPE, $
		FILT: 0L, $
		RA: 0.0, $
		RAU: 0.0, $
		DEC: 0.0, $
		DECU: 0.0, $
		ROLL: 0.0, $
		ROLU: 0.0, $
		AVGB: 0.0, $
		NPIX: 0L, $
		BRGT: fltarr(9), $
		BRGU: fltarr(9), $
		STAT: bytarr(9), $
		FILL: bytarr(3)  $
		}

;
; The PHTAAR data structure containing all the AutoAnalysis Result
;

  PHTAAR_REC = { PHTAAR_TYPE, $
		 ADMN: ' ',   $
		 TYPE: ' ',   $
		 HDR: 0L,     $
		 DATA: 0L$
		}

  PHTAAR = { PHTAAR_TYPE }

;
; The various description for the structures, mainly used for
; the pia_showstr routine for inspecting the data value
;

  PPAP_DESC = [ $
		'Filter ID (CHW3 position)', $
		'Aperture ID (CHW2 position)', $
		'Number of background reference positions', $
		'Source flux (Jy)', $
		'Uncertainty in source flux (Jy)', $
		'Background for given aperture (Jy)', $
		'Uncertainty in background (Jy)', $
		'Source plus background (Jy)', $
		'Uncertainty in source plus background (Jy)', $
		'Background at reference position 1 (Jy)', $
		'Uncertainty in background 1 (Jy)', $
		'Background at reference position 2 (Jy)', $
		'Uncertainty in background 2 (Jy)', $
		'Mean background intensity (MJy/sr)', $
		'Uncertainty in background intensity (MJy/sr)', $
		'Number of accepted chopper cycles', $
		'Filter Central Wavelength (microns)'	$
		]

		
  PPAE_DESC = [ $
		'Filter ID (CHW3 position)', $
		'Aperture ID (CHW2 position)', $
		'Number of background reference positions', $
		'Source brightness (MJy/sr)', $
		'Uncertainty in source brightness (MJy/sr)', $
		'Background for given aperture (MJy/sr)', $
		'Uncertainty in background (MJy/sr)', $
		'Source plus background (MJy/sr)', $
		'Uncertainty in source plus background (MJy/sr)', $
		'Background at reference position 1 (MJy/sr)', $
		'Uncertainty in background 1 (MJy/sr)', $
		'Background at reference position 2 (MJy/sr)', $
		'Uncertainty in background 2 (MJy/sr)', $
		'Number of accepted chopper cycles', $
		'Filter Central Wavelength (microns)' $  
		]

  PPAS_DESC = [ $
		'Filter ID (CHW3 position)', $
		'Right Ascension', $
		'Uncertainty', $
		'Declination', $
		'Uncertainty', $
		'Roll angle', $
		'Uncertainty', $
		'Surface brightness (MJy/sr)', $
		'Uncertainty in surface brightness (MJy/sr)', $
		'Status flag', $
		'Filler' $
		]

  PLAP_DESC = [ $
		'Dark background flag (1 if dark meas, 0 otherwise)', $
		'Number of background reference positions', $
		'Source (W /m^2 /um)', $
		'Uncertainty in Source (W /m^2 /um)', $
		'Mean Background (W /m^2 /um)', $
		'Uncertainty in Mean Background (W /m^2 /um)', $
		'Source + Background (W /m^2 /um)', $
		'Uncertainty in Source + Background (W /m^2 /um)', $
		'Background at reference position 1 (W /m^2 /um)', $
		'Uncertainty in Background 1', $
		'Background at reference position 2 (W /m^2 /um)', $
		'Uncertainty in Background 2', $
		'Central Wavelength of pixel (um)' $
		]

  PLAE_DESC = [ $
		'Dark background flag (1 if dark meas, 0 otherwise)', $
		'Number of background reference positions', $
		'Source (W /m^2 /um /sr)', $
		'Uncertainty in Source (W /m^2 /um /sr)', $
		'Mean Background (W /m^2 /um /sr)', $
		'Uncertainty in Mean Background (W /m^2 /um /sr)', $
		'Source + Background (W /m^2 /um /sr)', $
		'Uncertainty in Source + Background (W /m^2 /um /sr)', $
		'Background at reference position 1 (W /m^2 /um /sr)', $
		'Uncertainty in Background 1', $
		'Background at reference position 2 (W /m^2 /um /sr)', $
		'Uncertainty in Background 2', $
		'Central Wavelength of pixel (um)' $
		]
  PLAS_DESC = [ $
		'Dark background flag (1 if dark meas, 0 otherwise)', $
		'Right Ascension of raster point', $
		'Uncertainty in Right Ascension', $
		'Declination of raster point', $
		'Uncertainty in Declination', $
		'Roll angle', $
		'Uncertainty in roll angle', $
		'Source + Background (W /m^2 /um /sr)', $
		'Uncertainty in Source + Background (W /m^2 /um /sr)', $
		'Central Wavelength of pixel (um)' $
		]
  PSAP_DESC = [ $
		'Dark background flag (1 if dark meas, 0 otherwise)', $
		'Number of background reference positions', $
		'Source (W /m^2 /um)', $
		'Uncertainty in Source (W /m^2 /um)', $
		'Mean Background (W /m^2 /um)', $
		'Uncertainty in Mean Background (W /m^2 /um)', $
		'Source + Background (W /m^2 /um)', $
		'Uncertainty in Source + Background (W /m^2 /um)', $
		'Background at reference position 1 (W /m^2 /um)', $
		'Uncertainty in Background 1', $
		'Background at reference position 2 (W /m^2 /um)', $
		'Uncertainty in Background 2', $
		'Central Wavelength of pixel (um)' $
		]

  PSAE_DESC = [ $
		'Dark background flag (1 if dark meas, 0 otherwise)', $
		'Number of background reference positions', $
		'Source (W /m^2 /um /sr)', $
		'Uncertainty in Source (W /m^2 /um /sr)', $
		'Mean Background (W /m^2 /um /sr)', $
		'Uncertainty in Mean Background (W /m^2 /um /sr)', $
		'Source + Background (W /m^2 /um /sr)', $
		'Uncertainty in Source + Background (W /m^2 /um /sr)', $
		'Background at reference position 1 (W /m^2 /um /sr)', $
		'Uncertainty in Background 1', $
		'Background at reference position 2 (W /m^2 /um /sr)', $
		'Uncertainty in Background 2', $
		'Central Wavelength of pixel (um)' $
		]
  PSAS_DESC = [ $
		'Dark background flag (1 if dark meas, 0 otherwise)', $
		'Right Ascension of raster point', $
		'Uncertainty in Right Ascension', $
		'Declination of raster point', $
		'Uncertainty in Declination', $
		'Roll angle', $
		'Uncertainty in roll angle', $
		'Source + Background (W /m^2 /um /sr)', $
		'Uncertainty in Source + Background (W /m^2 /um /sr)', $
		'Central Wavelength of pixel (um)' $
		]
  PCAP_DESC = [ $
		'Filter ID (CHW2 position)', $
		'Number of background reference positions', $
		'Number of pixels defined', $
		'Source flux (Jy)', $
		'Uncertainty in source flux (Jy)', $
		'Source plus background (Jy)', $
		'Uncertainty in source plus background (Jy)', $
		'Background at reference position 1 (MJy/sr)', $
		'Uncertainty in background 1 (Jy/sr)', $
		'Background at reference position 2 (Jy/sr)', $
		'Uncertainty in background 2 (Jy/sr)', $
		'Fitted source peak (Jy)', $
		'Uncertainty in source peak (Jy)', $
		'Background at source position (Jy)', $
		'Uncertainty in background at source (Jy)', $
		'Avg. Background at off-source position 1', $
		'Uncertainty in background off-source 1 (Jy)', $
		'Avg. Background at off-source position 2', $
		'Uncertainty in background off-source 2 (Jy)', $
		'On-source background intensity (MJy/sr)', $
		'Uncertainty in background intensity on-source (MJy/sr)', $
		'Off-source background intensity 1 (MJy/sr)', $
		'Uncertainty in background intensity off-source 1 (MJy/sr)', $
		'Off-source background intensity 2 (MJy/sr)', $
		'Uncertainty in background intensity off-source 2 (MJy/sr)', $
		'(x,y) offset of source peak (arcsec)', $
		'(x,y) uncertainty in offset (arcsec)', $
		'Uncertainty of Gaussian fit (Jy)', $
		'Fit status', $
		'Number of accepted chopper cycles', $
		'Filter Central Wavelength (microns)' $
		]
  PCAE_DESC = [ $
		'Filter ID (CHW2 position)', $
		'Number of background reference positions', $
		'Number of pixels defined', $
		'Source brightness (MJy/sr)', $
		'Uncertainty in source brightness (MJy/sr)', $
		'Source plus background (MJy/sr)', $
		'Uncertainty in source plus background (MJy/sr)', $
		'Background at reference position 1 (MJy/sr)', $
		'Uncertainty in background 1 (Jy/sr)', $
		'Background at reference position 2 (Jy/sr)', $
		'Uncertainty in background 2 (Jy/sr)', $
		'Average background (MJy/sr)', $
		'Uncertainty in background (MJy/sr)', $
		'Avg. Background at off-source position 1', $
		'Uncertainty in background off-source 1 (MJy/sr)', $
		'Avg. Background at off-source position 2', $
		'Uncertainty in background off-source 2 (MJy/sr)', $
		'Number of accepted chopper cycles', $
		'Filter Central Wavelength (microns)'  $
		]
  PCAS_DESC = [ $
		'Filter ID (CHW2 position)', $
		'Right Ascension', $
		'Uncertainty', $
		'Declination', $
		'Uncertainty', $
		'Roll angle', $
		'Uncertainty', $
		'average brightness over array (MJy/sr)', $
		'Number of pixels defined', $
		'Surface brightness (MJy/sr)', $
		'Uncertainty in surface brightness (MJy/sr)', $
		'Status flag', $
		'Filler' $
		]
