;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTFCS
;
; PURPOSE:
;	Definition of the common block PHTFCS (Fine Calibration Source power
;	tables) for inclusion into other routines.  
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtfcs
;
; COMMON BLOCK PARAMETERS:
;	P1FCSPOW : The P1 FCS power table
;	P2FCSPOW : The P2 FCS power table
;	P3FCSPOW : The P3 FCS power table
;	C1FCSPOW : The C100 FCS power table
;	C2FCSPOW : The C200 FCS power table
;
; MODIFICATION HISTORY:
;	Wrtten by: Carlos GABRIEL, ESA/ESTEC 		October 1994
;	Oct 95 Version 3.5
;	Common extended with with validity limits (CG)	January 1998
;	V7.0 
;			
;-

	COMMON PHTFCS, p1fcspow, p2fcspow, p3fcspow, c1fcspow, c2fcspow, $
		p1fcsp_lim, p2fcsp_lim, p3fcsp_lim, c1fcsp_lim, c2fcsp_lim 
