;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTFFIELD
;
; PURPOSE:
;	Definition of the common block PHTFFIELD (External Flat Field
;	Factors) for inclusion into other routines.  
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtffield
;
; COMMON BLOCK PARAMETERS:
;	This file stores the external flat field factors
;
;	PHTFFIELD contains the following variables:
;
;	C1FLATF : The C100 Flatfield factors
;	C1FLATU : Uncertainties of C1FLATF
;	C2FLATF : The C200 Flatfield factors
;	C2FLATU : Uncertainties of C2FLATF
;
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL, ESA/ESTEC 		May 1997
;	V6.3
;			
;-

	COMMON PHTFFIELD, C1FLATF, C1FLATU, C2FLATF, C2FLATU
