;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTOMEGA
;
; PURPOSE:
;	Definition of the common block PHTOMEGA for inclusion into
;	other routines. This common block stores data about the phot
;	solid angles of pixels and aperture, as well as their apparent
;	sizes on the sky and relative off-sets. 
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtomega
;
; COMMON BLOCK PARAMETERS
;
;         C100-detector:
;
;         C1OFFY:   fltarr(9,7,2), fltarr(pixel,filter,value/uncertainty)
;                   Offset(") in y relative to centre of array
;         C1OFFZ:   fltarr(9,7,2), fltarr(pixel,filter,value/uncertainty)
;                   Offset(") in z relative to centre of array
;         C1SIZEY:  fltarr(9,7,2), fltarr(pixel,filter,value/uncertainty)
;                   Aperture dimension y (");         
;         C1SIZEZ:  fltarr(9,7,2), fltarr(pixel,filter,value/uncertainty)
;                   Aperture dimension z ("); 
;         C1OM:     fltarr(9,7,2), fltarr(pixel,filter,value/uncertainty)
;                   Omega (sr)
;
;         C200-detector:
;
;         C2OFFY:   fltarr(4,5,2), fltarr(pixel,filter,value/uncertainty)
;                   Offset(") in y relative to centre of array
;         C2OFFZ:   fltarr(4,5,2), fltarr(pixel,filter,value/uncertainty)
;                   Offset(") in z relative to centre of array
;         C2SIZEY:  fltarr(4,5,2), fltarr(pixel,filter,value/uncertainty)
;                   Aperture dimension y (");         
;         C2SIZEZ:  fltarr(4,5,2), fltarr(pixel,filter,value/uncertainty)
;                   Aperture dimension z ("); 
;         C2OM:     fltarr(4,5,2), fltarr(pixel,filter,value/uncertainty)
;                   Omega (sr)
;         
;         P-detectors:
;
;         PSIZEY:   fltarr(14,14,2), fltarr(aperture, filter, value/uncertainty)
;                   Aperture diameter (") in Y'
;
;         PSIZEZ:   fltarr(14,14,2), fltarr(aperture, filter, value/uncertainty)
;                   Aperture diameter (") in Z'
;
;         POM:      fltarr(14,14,2), fltarr(aperture, filter, value/uncertainty)
;                   Omega (sr)
;
; MODIFICATION HISTORY:
; 	Written by: Ingolf Heinrichsen
;       Jan 98 Version 1.0
;       V7.0
;			
;-
	
COMMON PHTomega, c1offy, c1offz, c1sizey, c1sizez, c1om, $
          c2offy, c2offz, c2sizey, c2sizez, c2om, $
          psizey, psizez, pom      






