;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PIACMN_POW2FB
;
; PURPOSE:
;	Definition of common block PIACMN_POW2FB
;	holds constants for the transformation from power to flux/brightness.
;
; CATEGORY:
;	PIA - common block
;
; CALLING SEQUENCE:
;	@PIACMN_POW2FB
;
; VARIABLES:
;	ppsf		A 15 x 14 float array of PSF values.
;	aper_m		Aperture values in m / m^2
;	aper_r		Aperture values in rad / sr
;	p_wavel		Central wavelengths of PHT-P filters [m]
;	c_wavel		Central wavelengths of PHT-C filters [m]
;	p_ratio		Response ratio of PHT-P filters [1/m]
;	c_ratio		Response ratio of PHT-C filters [1/m]
;
; MODIFICATION HISTORY:
;	Written by: D Skaley
;	Oct 95 Version 3.5
;-

	COMMON PIACMN_POW2FB, ppsf, aper_m, aper_r, p_wavel, c_wavel, $
				p_ratio, c_ratio
