;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	RASTER_INFO
;
; PURPOSE:
;	This is not an IDL routine as such, but contains the definition of the
;	common block RASTER_INFO for inclusion into other routines. By defining
;	the common block in one place, the problem of conflicting definitions
;	is avoided.
;
;	This file is included into routines that need this common block with
;	the single line (left justified)
;
;				  @raster_info
;
;
;	This file stores data about raster scans
;
;	RASTER_INFO contains the following variables:
;
;	Att_Type: P(oint), (R)aster or (T)racking
;	NPoints: Number of raster points
;	NLines: Number of raster lines
;	SPoints: Seperation of raster points
;	SLines: Seperation of raster lines
;	Ins_RA: RA of centre of field of view
;	Ins_DEC: DEC of centre of field of view
;	Roll: Roll angle
;	Orient: Raster orientation
;
;	MRaster: Misalignment of raster scanning
;	MPixel: Misalignment of PHT-C pixels
;	MChop: Misaligment of chopper throw
;
; CATEGORY:
;	PIA - common block
; PROCEDURES USED:
;
; MODIFICATION HISTORY:
;	Huw Morris, October 1994
;-

	COMMON Raster_Info, Att_Type, NPoints, NLines, SPoints, SLines, $
	       Ins_RA, Ins_DEC, Roll, Orient, $
	       MRaster, MPixel, MChop
