;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	CHOP_INFO
;
; PURPOSE:
;	This is not an IDL routine as such, but contains the definition of the
;	common block CHOP_INFO for inclusion into other routines.  By defining
;	the common block in one place, the problem of conflicting definitions
;	is avoided.
;
;	This file is included into routines that need this common block with
;	the single line (left justified)
;
;				  @chop_info
;
;
;	This file stores data from a single measurement about the chopper.
;
;	CHOP_INFO contains the following variables:
;
;	Mode : The chopper mode
;       SubMode: The chopper submode
;       Steps: The number of chopper steps
;	Plat: The number of chopper plateaux
;       Increment: The chopper increment
;
;	Dest_Read: The number of destructive read-outs
;	Int_Time: The integration time
;	Chop_Amp: The chopper amplitude
;
;	Start_Time: The start time of the measurement
;	Current_Time: Array of times for each readout within the measurement
;
;	Trans_Time_Meas: Chopper transition time for a measurement
;	Trans_Time_Cal: Chopper transition time for a calibration
;	Data_Red: Data Reduction 
;
; CATEGORY:
;	PIA - common block
;
; MODIFICATION HISTORY:
;	Written by:	Huw Morris
;	Modified by:	C. Gabriel
;	Oct 95 Version 3.5
;-

	COMMON Chop_info, Mode, Submode, Steps, Plat, Increment, Dest_Read, $
	       Int_Time, Chop_Amp, Start_Time, Current_Time, Raw_Chop, $
	       Trans_Time_Meas, Trans_Time_Cal, Data_Red
