;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTCS_INIT
;
; PURPOSE:
;	Definition of the PHTCS structure for inclusion into other routines.  
;
; CATEGORY:
;       PIA - initialization
;
; CALLING SEQUENCE:
;	@phtcs_init
;
; PROCEDURE:
;	PHTCS contains the following field definitions:
;
;		UNIT   = String corresponding to the 6 numbers identifying 
;			     the PHT CS (e.g. '123456' for PSTA123456.FITS) 
;		DIMS   = Actual dimension of the keywords corresponding to 
;			     the CSUNIT
;               All Compact Status Keywords CSGPXXXX as PSTAXXXX
;               All other Compact Status Keywords as in the archive 
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL (ESA/ESTEC)		 Dec 1993
;       Modified by: wmt				 July 1994
;	Oct 95 Version 3.5
;	Dummy structure deleted (CG)			November 1995
;			
;-
        PHTCS_REC_TYPE = {PHTCS_TYPE, $
                          UNIT: ' ', $
                          DIMS: 0L,  $
                          HANDLE: HANDLE_CREATE()}

        PHTCS = {PHTCS_TYPE}
