;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       Phterd_init
;
; PURPOSE:
;       Initializes the structure PHTERD defining the contents as
;	a template structure PHTERD_TYPE. It can be used for clearing
;	the whole ERD structure, in case this should show as necessary. 
;
; CALLING SEQUENCE:
;       @phterd_init
;
;
; COMMON BLOCKS:
;	phterd
;
; MODIFICATION HISTORY:
;       Written by: C. Gabriel                      	January 1994
;	Modified last by: CG, Wai-Ming Tai		September 1994
;	Oct 95 Version 3.5
;	PHTERD descriptor fixed - CG			February 1997
;	
;-
;
@phterd
        ON_ERROR, 2
;
	PHTERD_REC = {PHTERD_TYPE, UNIT: ' ', $
	DET: ' ',	$
	ADMN: ' ',      $
        ORDR: 0, 	$
        DIMS: 0L,	$ 
	TINT: 0.,	$
	NNDR: 0,	$
	RCHP: 0,	$
        HDR: HANDLE_CREATE(), $
        RAWP: HANDLE_CREATE(), $
        CONP: HANDLE_CREATE(), $
        FITV: HANDLE_CREATE(), $
        TIME: HANDLE_CREATE(), $
        PIXF: HANDLE_CREATE(), $
	CHOP: HANDLE_CREATE(), $
	STEP: HANDLE_CREATE(), $
	FCSN: HANDLE_CREATE(), $
	TEMP: HANDLE_CREATE(), $
	FCS1: HANDLE_CREATE(), $
	FCS2: HANDLE_CREATE(), $
        TKEY: HANDLE_CREATE(), $
        RPID: HANDLE_CREATE(), $
        FLAG: HANDLE_CREATE()}
; the first_handle is the index of the first handle in the
; structure and the last_handle is the index of the last
; handle, it is mainly used for clear the buffer. Define
; here would eliminate the need to change the erd_init
; for releasing the handle.
	ERD_FIRST_HANDLE = 8
	ERD_LAST_HANDLE = 22
	PHTERD_DESC = [ $
                'Acquisition date',                     $
                'Detector',                             $
                'Internal Name ',                       $
                'Order within TDT ',                    $
                'Dimensions    ',                       $
                'Integration time',                     $
                'Number of NDRs',                       $
                'Ramps / Chopper Pl',                   $
                'Header',                               $
                'Digitized Numbers',                    $
                'Pixel voltages',                       $
                'Fitted Voltages',                      $
                'Bit Flags accompanying pixels',	$
                'Time within Meas',                     $
                'Chopper position',                     $
                'Chopper step     ',                    $
                'FCS number       ',                    $
                'Temperature    ',                      $
                'FCS1 electrical power ',               $
                'FCS2 electrical power ',               $
                'Instrument time key    ',              $
                'Raster point ID        ',              $
		'Flag        ']
	PHTERD = {PHTERD_TYPE}
