;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       PhtIIPH_init
; PURPOSE:
;       Initializes the structure PHTIIPH defining the contents as
;	a template structure PHTIIPH_TYPE. It can be used for clearing
;	the whole IIPH structure, in case this should show as necessary. 
;
; CALLING SEQUENCE:
;       PHTIIPH_INIT
;
; INPUT PARAMETERS:
;	None       
;
; OUTPUT PARAMETERS: 
;	None
;
; PROCEDURES USED:
;       None
;
; MODIFICATION HISTORY:
;       Written by P. Merluzzi                       June 1995
;       Sky coordinates and roll angle                  August 1995
;       uncertainties added
;	modified due to changes of IIPH format		SB, December 1995
;	ADMN, SPR removed			        SB, July 1996
;	modified due to changes of IIPH format		SB, November 1996
;-
;
@phtiiph
        ON_ERROR, 2
;
	PHTIIPH_REC = {PHTIIPH_TYPE, UNIT: ' ', $
        HDR: HANDLE_CREATE(), $
        ADMN: ' ',            $
        DIMS: 0L,             $
        HANDLE: HANDLE_CREATE(), $
        UTK: HANDLE_CREATE(), $
        UTC: HANDLE_CREATE(), $
        RPD: HANDLE_CREATE(), $
        OTF: HANDLE_CREATE(), $
        FLT: HANDLE_CREATE(), $
        SPK: HANDLE_CREATE(), $
        ATQ: HANDLE_CREATE(), $
        STR: HANDLE_CREATE(), $
        RA: HANDLE_CREATE(),  $
        DEC: HANDLE_CREATE(), $
        RLL: HANDLE_CREATE()}
        PHTIIPH = {PHTIIPH_TYPE}

