;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTOPTPOW
;
; PURPOSE:
;	Definition and initialization of the common block PHTOPTPOW (Fine
;	Calibration Source illumo=ination power levels) for inclusion into
;	other routines.  
;
; CATEGORY:
;          PIA - initialization
;          PIA - common block
;
; CALLING SEQUENCE:
;	@phtoptpow
;
; COMMON BLOCK PARAMETERS:
;	This file stores the optical power data as used for
;	the production of the PHT FCS power tables
;
;	PHTOPTPOW contains the following variables:
;
;	LONGPOW :  The opt power values corresponding to the P detectors
;	SHORTPOW : The opt power values corresponding to the C detectors
;
; COMMON BLOCKS:
;	optpow
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL, ESA/ESTEC 			October 1994
;       Modified (last) by: CG   				April 1995
;	Oct 95 Version 3.5
;
;-
	COMMON optpow, LONGPOW, SHORTPOW

	LONGPOW = [1.78E-20,3.16E-20,5.62E-20, $
                   1.E-19,1.78E-19,3.16E-19,5.62E-19, $
                   1.E-18,1.78E-18,3.16E-18,5.62E-18, $
                   1.E-17,1.78E-17,3.16E-17,5.62E-17, $
                   1.E-16,1.78E-16,3.16E-16,5.62E-16, $
                   1.E-15,1.78E-15,3.16E-15,5.62E-15, $
                   1.E-14,1.78E-14,3.16E-14,5.62E-14, $
                   1.E-13,1.78E-13,3.16E-13,5.62E-13, $
                   1.E-12,1.78E-12,3.16E-12,5.62E-12, $
                   1.E-11,1.78E-11,3.16E-11,5.62E-11, $
                   1.E-10,1.78E-10,3.16E-10,5.62E-10, 1.E-09, 1.78E-09]
                  
	SHORTPOW = [1.E-18,1.78E-18,3.16E-18,5.62E-18, $
                   1.E-17,1.78E-17,3.16E-17,5.62E-17, $
                   1.E-16,1.78E-16,3.16E-16,5.62E-16, $
                   1.E-15,1.78E-15,3.16E-15,5.62E-15, $
                   1.E-14,1.78E-14,3.16E-14,5.62E-14, $
                   1.E-13,1.78E-13,3.16E-13,5.62E-13, $
                   1.E-12,1.78E-12,3.16E-12,5.62E-12, $
                   1.E-11,1.78E-11,3.16E-11,5.62E-11, 1.E-10]
                  
