;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       PhtScp_init
;
; PURPOSE:
;       Initializes the structure PHTSCP (Signals per Chopper Plateau) 
;	defining the contents as a template structure PHTSCP_TYPE. 
;	It can be used for clearing the whole SCP structure, in case 
;	this should show as necessary. 
;
; CATEGORY:
;       PIA - initialization
;
; CALLING SEQUENCE:
;       @phtscp_init
;
; COMMON BLOCKS:
;	phtscp
;
; MODIFICATION HISTORY:
;       Written by: C. Gabriel (ESA/ESTEC)                September 1994
;	Oct 95 Version 3.5
;	Extension for ANDR,AVSD and ARSI (CG)		  January 1996
;			
;-
;
@phtscp
        ON_ERROR, 2
;
	PHTSCP_REC = {PHTSCP_TYPE, UNIT: ' ', $
	DET: ' ',	$
	ADMN: ' ',	$
        ORDR: 0, 	$
        DIMS: 0L,	$ 
	HDR: HANDLE_CREATE(), $
        TIME: HANDLE_CREATE(), $
        AVER: HANDLE_CREATE(), $
        AVUN: HANDLE_CREATE(), $
	MEDI: HANDLE_CREATE(), $
	Q1ME: HANDLE_CREATE(), $
	Q3ME: HANDLE_CREATE(), $
	FLAG: HANDLE_CREATE(), $
	CHOP: HANDLE_CREATE(), $
	STEP: HANDLE_CREATE(), $
	FCSN: HANDLE_CREATE(), $
	TEMP: HANDLE_CREATE(), $
	FCS1: HANDLE_CREATE(), $
	FCS2: HANDLE_CREATE(), $
        TKEY: HANDLE_CREATE(), $
        RPID: HANDLE_CREATE(), $
	ARSI: HANDLE_CREATE(), $
        ANDR: HANDLE_CREATE(), $
        AVSD: HANDLE_CREATE()}
; the first_handle is the index of the first handle in the
; structure and the last_handle is the index of the last
; handle, it is mainly used for clear the buffer. Define
; here would eliminate the need to change the scp_init
; for releasing the handle.
	SCP_FIRST_HANDLE = 5
	SCP_LAST_HANDLE = 23
        PHTSCP_DESC = [ $
                'Acquisition date',                     $
                'Detector',                             $
                'Internal Name ',                       $
                'Order within TDT ',                    $
                'Dimensions    ',                       $
                'Header',                               $
                'Time within Meas',                     $
                'Average Signals/(Chopper Plateau)',   $
                'Average Signals uncertainty',		$
                'Median Signals/(Chopper Plateau)',    $
                'First Quartiles',                      $
                'Third Quartiles',                      $
                'Flag            ',                     $
                'Chopper position ',                    $
                'Chopper step     ',                    $
                'FCS number       ',                    $
                'Temperature    ',                      $
                'FCS1 electrical power ',               $
                'FCS2 electrical power ',               $
                'Instrument time key    ',              $
                'Raster point ID        ',              $
                'Mean effective reset time',            $
                'Mean nr. of read-outs used',           $
                'Sigma signals distribution '           $
        	]

	PHTSCP = {PHTSCP_TYPE}
