;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTVIGNET
;
; PURPOSE:
;	Definition of the common block VIGNET_TABLES (Chopper amplitude
;	dependent vignetting tables) for inclusion into other routines.  
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtvignet
;
; COMMON BLOCK PARAMETERS:
;	This common block holds the tables for the chopper-amplitude-dependant
;	vignetting.
;
;	PP1Vign             ; P1
;	PP2Vign             ; P2
;	PP3Vign             ; P3
;
;	PC1Vign	            ; C100
;	PC2Vign             ; C200
;
;	There is no vignetting done for PHT-S
;
; MODIFICATION HISTORY:
; 	Written by:	Huw Morris (DRAL)		October 1994
;	Oct 95 Version 3.5
;			
;-

	COMMON PHTVignet, PP1Vign, PP2Vign, PP3Vign, PC1Vign, PC2Vign
