;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	DEGLITCH_PARAM
;
; PURPOSE:
;	This is not an IDL routine as such, but contains the definition of the
;	common block DEGLITCH_PARAM for inclusion into other routines.  By 
;	defining the common block in one place, the problem of conflicting 
;	definitions is avoided.
;
;	This file is included into routines that need this common block with
;	the single line (left justified)
;
;				  @deglitch_param
;
;	This file stores the parameters for the deglitching routine:
;	
;	Min_Deglitch: Minimum number of slopes required to perform the
;	              filtering algorithm
;	Max_Error: Maximum error before a point is flagged
;	Max_Iter: Maximum number of iterations to perform
;	Num_Bad: Number of times a pixel has to be flagged before it is
;	         rejected
;	Num_Local: Number of slopes in the local distribution
;	Num_Sigma: Number of sigmas from the median a slope must be
;	           to be flagged.
;	Num_Step: Number of points to step
;	Per_Chop: Set for deglitch per chopper plateaux 
;	Degl_Clip: If not equal 0, maximum/minimum clipping is used for 
;		   determining sigma
;
; CATEGORY:
;	PIA - common block
;
; MODIFICATION HISTORY:
;	Written by:	Huw Morris
;	Extended by CG		November 1996
;	V5.x
;-

	COMMON Deglitch_Params, Min_Deglitch, Max_Error, Max_Iter, Num_Bad, $
	       Num_Local, Num_Sigma, Num_Step, Per_Chop, Per_Raster, Degl_Clip
