;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.!
 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             !
 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             !
 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       PHTAAR
;
; PURPOSE:
;       Definition of the common block PHTAAR (Auto Analysis Results) 
;       for inclusion into other routines.
;
;
; CALLING SEQUENCE:
;       @phtaar
;
; CATEGORY:
;          PIA - common block
;
; COMMON BLOCK PARAMETERS:
;	PPAP_TYPE: PHT-P point source photometry structure
;	PPAE_TYPE: PHT-P extended source photometry structure
;	PPAS_TYPE: PHT-P scan & slew photometry structure
;	PLAP_TYPE: PHT-SL point source spectroscopy structure
;	PLAE_TYPE: PHT-SL extended source spectroscopy structure
;	PLAS_TYPE: PHT-SL Raster mode spectroscopy structure
;	PSAP_TYPE: PHT-SS point source spectroscopy structure
;	PSAE_TYPE: PHT-SS extended source spectroscopy structure
;	PSAS_TYPE: PHT-SS Raster mode spectroscopy structure
;	PCAP_TYPE: PHT-C point source photometry structure
;	PCAE_TYPE: PHT-C extended source photometry structure
;	PCAS_TYPE: PHT-C scan & slew photometry structure
;
; MODIFICATION HISTORY:
;       Written by: Wai-Ming Tai (DIAS) Apr 1996
;	FITS_... and *_DESC added (WMT) May 1996
;-
COMMON PHTAAR, PPAP_BUF, FITS_PPAP_BUF, PPAE_BUF, FITS_PPAE_BUF, PPAS_BUF, $
	       PLAP_BUF, PLAE_BUF, PLAS_BUF, $
               PSAP_BUF, PSAE_BUF, PSAS_BUF, $
	       FITS_PLAP_BUF, FITS_PLAE_BUF, FITS_PLAS_BUF, $
               FITS_PSAP_BUF, FITS_PSAE_BUF, FITS_PSAS_BUF, $
	       PCAP_BUF, FITS_PCAP_BUF, PCAE_BUF, FITS_PCAE_BUF, PCAS_BUF, $
               PPAP_DESC, PPAE_DESC, PPAS_DESC, $
	       PLAP_DESC, PLAE_DESC, PLAS_DESC, $
	       PSAP_DESC, PSAE_DESC, PSAS_DESC, $
  	       PCAP_DESC, PCAE_DESC, PCAS_DESC, $
	       PHTAAR, PHTAAR_REC
