;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTACC
; PURPOSE:
;	Define common block ACC for information about acceptance/discarding 
;	of data points.
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtacc
;
; COMMON BLOCK PARAMETERS:
;	NSELNDR : 1 if general NDR selection criteria used, 0 if not
;	DRNACC	: 0 if DR to be accepted, 1 if not 
;	NDR1NAC : 0 if first NDR to be accepted, 1 if not
;	NDRNACC	: Array of NDRs (relative position within ramp) to be neglected
;       MINR	: First Ramp (absolute position within meas) to be accepted
;	MAXR  	: Last Ramp (absolute position) to be accepted
;	ANYR	: Array of read-outs (absolute position) to be neglected 
;	MINVOLT : Minimum voltage to be accepted
;	MAXVOLT : Maximum voltage to be accepted
;	SIGTNACC: Structure: {chop_meas:FLT,star_meas:FLT} indicating fraction
;			      of chopper plateau discarded for chopped and
;			      staring or raster measurements
;	SIG1ACC : 0 if first Signal/Chopper Plateaux to be accepted, 1 if not
;	SIGNACC	: Array of Signals (relative position within chopper plateaux)
;		  to be neglected
;	MINSIG	: First Signal (absolute position) to be accepted
;	MAXSIG	: Last Signal (absolute position) to be accepted
;	ANYSIG	: Array of Signals (absolute position) to be neglected 
;	SCPNACC	: Array of contiguous Chopper Plateaux to be neglected
;	MINCP	: First Chopper Plateau to be used
;	MAXCP	: Last Chopper Plateau to be used
;	ANYCP	: Array of individual (non-contiguous) Ch.Pl. to be neglected
;	SPDNACC	: Array of cont. Chopper Plateaux (SPD level) to be neglected
;	MINSCP	: First Chopper Plateau to be used (SPD level)
;	MAXSCP	: Last Chopper Plateau to be used (SPD level)
;	ANYSCP	: Array of individual (non-contiguous) Ch.Pl. to be neglected
;
; MODIFICATION HISTORY:
;	Written by: Carlos Gabriel (ESA/ESTEC)
;	Oct 95 Version 3.5
;
;-
;
	COMMON PHTACC, 	NSELNDR, DRNACC, NDR1NAC, NDRNACC, MINR, MAXR, ANYR, $
		       	MINVOLT, MAXVOLT, $
                        SIGTNACC, SIG1ACC, SIGNACC, MINSIG, MAXSIG, ANYSIG, $
			SCPNACC, MINCP, MAXCP, ANYCP, $ 
			SPDNACC, MINSCP, MAXSCP, ANYSCP 
