;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTAPERT
;
; PURPOSE:
;	Definition of the common block APERTURE_SIZE for inclusion into
;	other routines. This common block stores data about the phot
;	aperture and pixels sizes and areas (mm, mm**2) and their
;	shapes.  
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtapert
;
; COMMON BLOCK PARAMETERS
;
;         P_DIAMY : PHT-P Diameter(mm) of aperture in Y, fltarr(14,2),
;                   fltarr(aperture, value/uncertainty)
;         P_DIAMZ : PHT-P Diameter(mm) of aperture in Z, fltarr(14,2),
;                   fltarr(aperture, value/uncertainty)
;         P_AREA:   PHT-P Area(mm**2) of aperture, fltarr(14,2),
;                   fltarr(aperture, value/uncertainty)
;         P_Shape : PHT-P aperture shapes
;
;         C1_DIAMY : PHT-C100 Diameter(mm) of pixel in Y, fltarr(2),
;                    fltarr(value/uncertainty)
;         C1_DIAMZ : PHT-C100 Diameter(mm) of pixel in Z, fltarr(2),
;                    fltarr(value/uncertainty)
;         C1_AREA:   PHT-C100 Area(mm**2) of pixel, fltarr(2),  
;                    fltarr(aperture, value/uncertainty)
;
;         C2_DIAMY : PHT-C200 Diameter(mm) of pixel in Y, fltarr(2),
;                    fltarr(value/uncertainty)
;         C2_DIAMZ : PHT-C200 Diameter(mm) of pixel in Z, fltarr(2),
;                    fltarr(value/uncertainty)
;         C2_AREA:   PHT-C200 Area(mm**2) of pixel, fltarr(2),  
;                    fltarr(aperture, value/uncertainty)
;
;
; MODIFICATION HISTORY:
; 	Written by: Ingolf Heinrichsen
;       Jan 98 Version 1.0
;       V7.0
;			
;-

	COMMON PHTApert,  P_DIAMY, P_DIAMZ,P_AREA, P_Shape, $
                          C1_DIAMY, C1_DIAMZ, C1_AREA, $
                          C2_DIAMY, C2_DIAMZ, C2_AREA





