;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTFPSF
;
; PURPOSE:
;	Definition of the common block PHTFPSF (Single pixel fpsf factors)
;	for inclusion into other routines.  
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtfpsf
;
; COMMON BLOCK PARAMETERS:
;	This file stores the single pixel fpsf factors
;
;	PHTFPSF contains the following variables:
;
;	phtfpsf: Structure containing
;			cpsf: central fpsf values
;			lpsf: lateral fpsf  [f(46)-C100, f(92)-C200]
;			dpsf: diagonal fpsf [f(46SQRT2)-C100, f(92SQRT2)-C200] 
;
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL, ESA/VILSPA 		June 1999
;	V7.4
;			
;-
COMMON phtfpsf, phtfpsf	
