;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTRESACT
;
; PURPOSE:
;	Definition of the common block PHTRESACT (Actual Detector 
;	Responsivities and Uncertainties) for inclusion into other routines.
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtresact
;
; COMMON BLOCK PARAMETERS:
;	This file stores data corresponding to (calculated) PHT responses
;
;	PHTRESACT contains the following variables:
;
;	P1RESPACT : The P1 detector response
;	P1RESPUNC : Uncertainty of P1RESPACT
;	P2RESPACT : The P2 detector response
;	P2RESPUNC : Uncertainty of P2RESPACT
;	P3RESPACT : The P3 detector response
;	P3RESPUNC : Uncertainty of P3RESPACT
;	C1RESPACT : Array: The C100 9 pixel responses
;	C1RESPUNC : Uncertainties of C1RESPACT
;	C2RESPACT : Array: The C200 4 pixel responses
;	C2RESPUNC : Uncertainties of C2RESPACT
;	SLRESPACT : Array: The S 128 pixel responses 
;	SLRESPUNC : Uncertainties of SLRESPACT
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL, ESA/ESTEC 		October 1994
;	Oct 95 Version 3.5
;	Extended with origin measurements names and filters (CG)  Jul 97
;	V6.4
;			
;-

	COMMON PHTRACT, p1respact, p2respact, p3respact, c1respact, $
			  c2respact, slrespact, $
			  p1respunc, p2respunc, p3respunc, c1respunc, $
			  c2respunc, slrespunc, $
			  respact_origin
	IF N_ELEMENTS(respact_origin) EQ 0 THEN $
	 respact_origin = {p1n:'',p2n:'',p3n:'',c1n:'',c2n:'',sln:'', $
			   p1f:'',p2f:'',p3f:'',c1f:'',c2f:'',slf:'', $
			   p1m:'',p2m:'',p3m:'',c1m:'',c2m:'',slm:''}
