;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTW2JY
;
; PURPOSE:
;	Definition of the common block PHTW2JY for inclusion into routines.
;	The common block PHTW2JY contains the conversion factors needed for
;	flux density and brightnes density extractions from in-band powers.
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtw2jy
;
; COMMON BLOCK PARAMETERS:
;	W2JY_P:	Conversion factors (W->Jy) for P1, P2, P3 (per filter)
;	W2JY_C: Conversion factors (W->Jy) for C100, C200 (per filter)	
;	V2JY_S: Conversion factors for PHT-S (Amperes->Jy) (per PHT-S pixel)
;		(this are the calibrated factors) containing the A to 
;		Jy calibration.  
;	W2JY_S: Conversion factors for PHT-S (W->Jy)
;	W2MJY_S: Conversion factors for PHT-S (W->MJy/sr)
;	
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL(ESA/VILSPA-SAI) 		March 1996
;	Changed (last) by CG - common extended for v2my		January 1997
;	V6.0
;
;-

	COMMON PHTvw2jy, w2jy_p, w2jy_c, v2jy_s, v2jyunc_s, w2jy_s, w2mjy_s, $
					v2mjy_s, v2mjyunc_s
	
