;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       ADM_INIT
;
; PURPOSE:
;       Initializes the structure ADM defining the contents as
;	a template structure ADM_TYPE for accomodating IA administration
;	data. It can be used also for clearing
;	the whole ADM structure, in case this should show as necessary. 
;
;
; CATEGORY:
;	PIA - Initialisation
;
; CALLING SEQUENCE:
;       ADM_INIT
;
; INPUTS:
;	None       
;
; OUTPUTS: 
;	None
;
; COMMON BLOCKS:
;	adm
;
; SIDE EFFECTS:
; 	Initialises the values held within the adm common block
;
; PROCEDURES USED:
;       None
;
; MODIFICATION HISTORY:
;       Written by:	 C. Gabriel and Wai-Ming Tai
;	Oct 95 Version 3.5
;
;	Modified:
;	PHTSMD, PHTISMD taken out (SB)			August 1996
;-
;
@adm
        ON_ERROR, 2
;
	ADM_REC = {ADM_TYPE, NAME: ' ', PHTCS: -1L, $
	  PHTERD: -1L, PHTSRD: -1L, PHTSCP: -1L, PHTSPD: -1L,  PHTCLA: -1L, $
	  PHTIERD: -1L,PHTISRD: -1L,PHTISCP: -1L,PHTISPD: -1L, PHTICLA: -1L, $
          PHTIIPH: -1L, PHTSMC: -1L, PHTISMC: -1L }
	ADM = {ADM_TYPE}
