;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	APERTURE_INFO
;
; PURPOSE:
;	This is not an IDL routine as such, but contains the definition of the
;	common block APERTURE_INFO for inclusion into other routines.  By 
;	defining the common block in one place, the problem of conflicting 
;	definitions is avoided.
;
;	This file is included into routines that need this common block with
;	the single line (left justified)
;
;				  @aperture_info
;
;
;	This file stores data about the phot apertures
;
;	APERTURE_INFO contains the following variables:
;
;	  N_Filt : Number of filters (PHT-P, PHT-C)
;
;	  N_Aper : Number of apertures for PHT-P
;
;	  P_WaveL : Centre wavelengths for PHT-P (array)
;
;	  C_WaveL : Centre wavelengths for PHT-C (array)
;
;	  P_Ratio : Relative detector response at the central wavelength
;
;	  C_Ratio : Relative detector response at the central wavelength
;
;	  Point_Spread : Point Spread Function for PHT-P, PHT-C
;
; CATEGORY:
;	PIA - common block
;
; MODIFICATION HISTORY:
;	Written by:	Huw Morris
;	Oct 95 Version 3.5
;-

	COMMON Aperture_info, N_Filt, N_Aper, P_WaveL, C_WaveL, $
	       P_Ratio, C_Ratio, Point_Spread
