;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	ROUTINE_NAME
;
; PURPOSE:
;	Include help text for pia_multi_fit
;
; CATEGORY:
;          PIA - support
;
; 	Used with kind permission of the SWS IDT. Imported into PIA from SWS 
;	interactive analysis routine library.
;	    
;#> multi_fit_help.dc1
; Identifier     multi_fit_help.pro
;
; Purpose        Including help text for multi_fit.pro  
;
; Synopsis       multi_fit_help, help_ident
;                                    
; Arguments      Name           I/O   Type     Description
;                -----------------------------------------------------
;                help_ident      I    string    help ident
;                
; Returns        ---
;
; Description    ---    
;
; Comment        Currently in german 
;               
; Example        ---
;
; Category       CAS
;
; Filename       multi_fit_help.pro
;
; Author         K.Seidenschwang
;
; Version        1.0
;
; History        1.0  03-apr-1995  --> KS  first draft
;#<
;-

PRO MULTI_FIT_HELP, HELP_IDENT

CASE HELP_IDENT(1) OF
 1   : TEXT = $
       ['Allgemein :'                                              , $
	'MULTI_FIT ist ein Fit_Programm,'                          , $
	'gefittet werden mehrere Peaks gleichzeitig.'              , $
	'In einer Graphik werden die gegebenen Werte X,Y,'         , $
	'und der Fit gezeichnet.'                                  , $
	' Eine weitere Graphik zeigt den Residuen-Plot.'           , $
	'Als Naeherungs_Funktionen stehen zur Verfuegung:'         , $
	'POLYNOM'                                                  , $
	'	f(x)=a(n)*x^n + a(n-1)x^(n-1) +...+ a(0)'          , $
	'	auch zur Bestimmung des BACKGROUND = a0'           , $
	'GAUSS'                                                    , $
	'	f(x)=a0*exp(-z^2/2) mit z=(x-a1)/a2'               , $
	'	a0 = height of exp, a1 = center of peak,'          , $
	'	a2 = 1/e width'                                    , $
	'(SIN(X)/X)^2'                                             , $
	'	f(x)=a0*(sin(a1*(x-a2))/(a1*(x-a2)))^2'            , $
	'	a0 = height, a1 = phase width, a2 = center'        , $
	'EXPO'                                                     , $
	'	f(x)=a0*exp(-abs(x-a1)/a2)'                        , $
	'	a0 = height of exp, a1 = center of peak,'          , $
	'	a2 = 1/e width'                                    , $
	'CAUCHY'                                                   , $
	'	f(x)=a0/(1+(2*(x-a1)/a2)^2)'                       , $
	'	a0 = height, a1 = center, a2 = fwhm'               , $
	'Als Fit_Funktion wird CURVEFIT verwendet,'                , $
	'wird nur mit POLYNOM gefitted, wird POLYFITW aufgerufen.' , $
	'Beim Aufruf von CURVEFIT muessen die Parameter a mit'     , $
	'Naeherungswerten vorbesetzt sein.'                        , $
	'Aufruf:'                                                  , $
	'MULTI_FIT,XIN,YIN,XOUT=XOUT,YOUT=YOUT,WEIGHT=WEIGHT,'     , $
	'          A=A,SIGMAA=SIGMAA,'                             , $
	'          XRANGE=XRANGE,YRANGE=YRANGE,PSYM=PSYM'          , $
	'XIN,YIN : Eingabewerte, Vector,'                          , $
	'          intern Umwandlung in FLOAT-Werte.'              , $
	'XOUT    : X-Werte zum Fit, optionaler Ausgabewert, Vector', $
	'YOUT    : Fit, optionaler Ausgabewert, Vector'            , $
	'          XOUT und YOUT sind nach steigendem X sortiert,' , $
	'          FLOAT - Werte'                                  , $
	'WEIGHT  : Gewichtung, optionaler Eingabewert, Vector'     , $
	'XRANGE  : Anfangs-Rechenbereich in X_Werten,'             , $
	'          optionaler Eingabewert'                         , $
	'YRANGE  : nur fuer graphische Darstellung,'               , $
	'          optionaler Eingabewert'                         , $
	'A       : Parameter aller Funktionen, Vector,'            , $
	'SIGMAA  : optionaler Ausgabewert'                         , $
	'	wird nur mit Polynom gefitted:'                   , $
	'	Standard Deviation in Y-Units, Scalar'            , $
	'	sonst:'                                           , $
	'	Standard Deviations for the Parameters, Vector.'  , $
	'	Fuer Parameter, deren Wert mit Button FIX'        , $
	'	waehrend der Iteration festgehalten wurde,'       , $
	'	wird 0.0 gesetzt.'                                , $
	'PSYM    : Symbol fuer Darstellung der Eingabewerte X,Y'  , $
	'	optionaler Eingabewert, Default=3']
 2   : TEXT = $
       ['BASE_FUNCTION:' , $
	'	Als Basis-Funktion ist ein Polynom 1.Grades'  , $
	'	vorgegeben, der Grad kann in der Zeile DEGREE', $
	'	veraendert werden, Bestaetigung mit <RETURN>' , $
	'	oder <OK> ist erforderlich. Der Wert a0 des'  , $
	'	Polynoms dient als BACKGROUND fuer weitere'   , $
	'	Funktionen. Nach Eingabe weiterer Funktionen' , $
	'	ist keine Aenderung von DEGREE mehr moeglich.']
 3   : TEXT = $
       [' +  :' , $
	'	Oeffnet das Auswahlmenue der Fit-Funktionen, die'  , $
	'	zusaetzlich zum Basis-Polynom gewaehlt werden.'    , $
	'	Die Anzahl der zusaetzlichen Funktionen ist durch' , $
	'	die Groesse des Parameter-Feldes a (=50) begrenzt.', $
	'	Die gewaehlten Funktionen werden im Feld'          , $
	'	" +  FUNCTION " angezeigt.']
 5   : TEXT = $
       ['SELECTION.ALLGEMEIN :' , $
	'	Aktiviert das Eingabefeld fuer die Selection.'   , $
	'	Die Selection ermoeglicht die Berechnung ueber'       , $
	'	einen - mit Hilfe des Cursors oder durch manuelle'    , $
	'	Eingabe	in die Felder bei MIN und MAX - ausgewaehlten', $
	'	X-Bereich.'                                           , $
	'	Der selektierte Bereich wird angezeigt,'              , $
	'	der graphische Bereich nicht geaendert.'              , $
	'	Die Eingabe muss in der Zeile INPUT mit OK'           , $
	'	bestaetigt werden.'                                   , $
	'	Nach Aufruf von PAR_INPUT ist keine Aenderung der'    , $
	'	Selektion mehr moeglich.']
 6   : TEXT = $
       ['SELECTION.ALL :' , $
	'	Der gesamte graphische Bereich ( XRANGE ) wird als' , $
	'	selektierter Bereich gesetzt.']
 7   : TEXT = $
       ['SELECTION.RESET :' ,$
	'	Der selektierte Bereich wird auf den bei Aufruf'  , $
	'	von SELECTION gueltigen Bereich gesetzt,'         , $
	'	eventuelle Aenderungen rueckgaengig gemacht.']
 8   : TEXT = $
       ['SELECTION.OK :'  , $
        '	Uebernahme des angezeigten selektierten Bereichs'  , $
        '	zur Berechnung, in den Feldern MIN und MAX werden' , $
        '	die tatsaechlich vorhandenen X-Werte angezeigt.'   , $
        '	Loescht das Eingabefeld fuer Selektion.']
 9   : TEXT = $
       ['SELECTION.CANCEL :' ,$
        '	Der selektierte Bereich wird auf den bei Aufruf'  , $
        '	von SELECTION gueltigen Bereich zurueckgesetzt,'  , $
        '	eventuelle Aenderungen rueckgaengig gemacht,'     , $
        '	loescht das Eingabefeld fuer Selektion.']
10   : TEXT = $
       ['SELECTION.CURSOR_MIN :' , $
        '	Aktiviert den Cursor fuer die Bestimmung des' , $
        '	unteren Grenzwertes des Rechenbereichs (MIN)' , $
        '	aus der Graphik.']
11   : TEXT = $
       ['SELECTION.CURSOR_MAX :' , $
        '	Aktiviert den Cursor fuer die Bestimmung des' , $
        '	oberen Grenzwertes des Rechenbereichs (MAX)' , $
        '	aus der Graphik.']
12   : TEXT = $
       ['SELECTION.MIN, MAX :' , $
        '	Anzeige des unteren und oberen Grenzwertes des'    , $
        '	Rechenbereichs, kann mit Hilfe des Cursors (s.o.)' , $
        '	und durch Edition veraendert werden, solange das'  , $
        '	Eingabefeld fuer SELECTION aktiv ist.']
14   : TEXT = $
       ['PAR_INPUT.ALLGEMEIN :' , $
	'	Aktiviert das Fenster fuer die Parameter-Eingabe.' , $
	'	Bei der Anwendung von CURVEFIT muessen Naeherungs-', $
	'	werte als Anfangsparameter vorgegeben werden.'     , $
	'	Wird nur mit Polynom + 1 Zusatzfunktion gefitted,' , $
	'	werden vom Programm Anfangsparameter angeboten.'   , $
	'	Die Parameter koennen durch Editieren oder aus'    , $
	'	der Graphik mit Hilfe des Cursors bestimmt werden.', $
	'	Die Parameter muessen mit OK bestaetigt werden.'   , $
	'	Parametereingabe beim Fit mit POLYFITW ist nicht'  , $
	'	moeglich.']
16   : TEXT = $
       ['PAR_INPUT.CURSOR.ALLGEMEIN :' , $
	'	Aktiviert den Cursor zur Bestimmung von Parametern' , $
	'	aus der Graphik und oeffnet ein Eingabefenster.']
17   : TEXT = $
       ['PAR_INPUT.CURSOR.OK :' , $
	'	Uebergibt die im Fenster "PARAMETER CURSOR-EINGABE" ', $
	'	angezeigten Parameterwerte an Parameter-Definition.' , $
	'	Werte mit der Anzeige "NOT DEF." werden nicht uebergeben.']
18   : TEXT = $
       ['PAR_INPUT.CURSOR.RESET :' , $
	'	Loescht alle Eingaben im Fenster' , $
	'	 "PARAMETER CURSOR-EINGABE". ']
19   : TEXT = $
       ['PAR_INPUT.CURSOR.FUNCTION :' , $
	'	Der Button mit der Anfangseinstellung "(0) POLY" '  , $
	'	enthaelt ein Auswahl-Menu der gewaehlten Fit-Funktionen.', $
	'	Die cursor-bestimmten Parameter werden mit OK fuer' , $
	'	die angezeigte Funktion uebergeben.']
20   : TEXT = $
       ['PAR_INPUT.CURSOR.PARAMETER :' , $
	'	Fuer die Funktion "(0) POLY" ist nur die Eingabe von', $
	'	BACKGR moeglich, fuer die weiteren Funktionen nur'   , $
	'	HEIGHT,CENTER,WIDTH.'                                , $
	'	Fuer die Bestimmung von HEIGHT und WIDTH muessen'    , $
	'	jeweils 2 Werte ermittelt werden. Fuer HEIGHT wird'  , $
	'	die Differenz zwischen zweitem und erstem Wert,'     , $
	'	fuer Width der Betrag der Differenz uebergeben.'     , $
	'	Fehlt die zweite Angabe, gilt der Wert als nicht'    , $
	'	cursor-definiert.'                                   , $
	'	Fuer die Funktion (SIN(X)/X)^2  wird "WIDTH" bei'    , $
	'	der Uebergabe ins Parameter-Feld modifiziert (!pi/width).']
21   : Text = $
       ['PAR_INPUT.VAR :' , $
	'	Durch Umschalten des Button VAR auf FIX koennen'    , $
	'	einzelne Parameter, deren genauer Wert bekannt ist,', $
	'	waehrend des FIT festgehalten werden.']
22   : Text = $
       ['PAR_INPUT.OK :' , $
	'	Loescht das Fenster zur Parameter-Eingabe mit Cursor.', $
	'	Uebergibt die Parameter als Anfangswerte fuer CURVEFIT',$
	'	Parameter, denen kein Wert zugewiesen wurde, werden' , $
	'	auf den Wert 0.0 gesetzt.'                          , $
	'	Liest VAR/FIX aus.']
23   : TEXT = $
       ['PAR_INPUT.RESET :' , $
	'	Loescht das Fenster zur Parameter-Eingabe mit Cursor.', $
	'	Loescht die vom Benutzer eingegebenen Werte fuer die' , $
	'	Parameter, setzt alle Parameter auf VAR.']
24   : TEXT = $
       ['FIT :' , $
	'	Ruft CURVEFIT oder POLYFITW,'  , $
	'	zeichnet Fit in Graphik,'      , $   
	'	zeichnet Residuen-Plot'        , $
	'	gibt die berechneten Parameter im Parameter-Fenster aus.']
25   : TEXT = $
       ['CANCEL :' , $
	'	Rueckkehr zu den Bedingungen am Anfang des'    , $
	'	Programm-Aufrufs.'                              , $
	'	ACHTUNG : Der graphische Bereich (XRANGE) wird', $
	'	nicht zurueckgesetzt und muss bei Bedarf mit'  , $
	'	NEW RANGE neu gesetzt werden.']
26   : TEXT = $
       ['FILE_I/O :' , $
	'	Oeffnet ein Auswahlmenue mit dem Angebot:'      , $
	'	RESTORE, SAVE, VIEW'                            , $
	'	RESTORE:Oeffnet Fenster zur Angabe eines File-' , $
	'		namens, um die Ergebnisse einer voran-' , $
	'		gegangenen Fit-Berechnung (mit SAVE ge-', $
	'		speichert) zur weiteren Berechnung zu'  , $
	'		laden. Der Filename muss mit OK bestaetigt' , $
	'		werden. Die Daten muessen mit den Eingabe-' , $
	'		daten des Programmaufrufs uebereinstimmen.' , $
	'		Das Programm wird zur Weiterarbeit mit den' , $
	'		geladenen Daten eingestellt.'               , $
	'	SAVE :	nur moeglich nach FIT,'                 , $
	'		oeffnet Fenster zur Angabe eines File-' , $
	'		namens, um die Ergebnisse einer Fit-'   , $
	'		berechnung fuer weitere Berechnung'     , $
	'		zu speichern. Der Filename muss mit OK' , $
	'		bestaetigt werden.'                     , $
	'	VIEW :	nur moeglich nach FIT.'                 , $
	'		Oeffnet Auswahlmenue mit den Moeglichkeiten' , $
	'		DISPLAY und PRINT_FILE.'                     , $
	'		DISPLAY oeffnet ein Fenster und zeigt die'   , $
	'		Ergebnisse der Fitberechnung am Bildschirm.' , $
	'		PRINT_FILE oeffnet ein Fenster zur Angabe'   , $
	'		eines Filenamens um die Ergebnisse des Fit'  , $
	'		auf ASCII-File zu speichern. Der Filename'   , $
	'		muss mit OK bestaetigt werden.'              , $
	'		ACHTUNG: der File enthaelt die (selektierten)',$
	'		X, Y, YFIT - Werte und kann sehr gross sein,', $
	'		rechtzeitig wieder loeschen!']
27   : TEXT = $
       ['NEW RANGE :' , $
	'	Oeffnet Fenster, um den graphischen Bereich' , $
	'	und damit den Rechenbereich zu aendern.'     , $
	'	Die Eingabe muss mit OK bestaetigt werden.']
28   : TEXT = $
       ['EXIT :' , $
	'	Schliesst alle Fenster,' , $
	'	Besetzt die Ausgabewerte' , $
	'	Programmausstieg.']
ELSE : TEXT = $
       'Bitte noch einmal NEXT druecken'
ENDCASE
WIDGET_CONTROL,HELP_IDENT(0),SET_VALUE = TEXT
END ; ENDE HILFE_TEXT
