;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHT_S
;
; PURPOSE:
;	This is not an IDL routine as such, but contains the definition of the
;	common block PHT_S for inclusion into other routines.  By 
;	defining the common block in one place, the problem of conflicting 
;	definitions is avoided.
;
;	This file is included into routines that need this common block with
;	the single line (left justified)
;
;				  @pht_s
;
;
;	This file stores data about PHT-S detector responses
;
;	PHT_S contains the following variables:
;
;	  S_PSF : Point spread function (array)
;	  S_WaveL : Centre wavelengths for each pixel (array)
;	  S_Ratio : Relative detector response at the central wavelength (array)
;	  S_Trans : Transmission of the beam path (array)
;
;	  DLambdaSS : Spectral bandwidth for PHT-SS
;	  DLambdaSL : Spectral bandwidth for PHT-SL
;
;	  Area : Primary mirror area in m^2
;
;	  S_SR : Solid angle of the aperture in steradians
;
; CATEGORY:
;          PIA - common block
;
; MODIFICATION HISTORY:
;	Wrtten by: Huw Morris (DRAL), February 1995
;	Oct 95 Version 3.5
;-

	COMMON pht_s, S_PSF, S_WaveL, S_Ratio, S_Trans, DLambdaSS,  $
	       DLambdaSL, Area, S_SR
