;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTAPERTURES
;
; PURPOSE:
;	Definition of the common block APERTURE_SIZE for inclusion into
;	other routines. This common block stores data about the phot aperture
; 	diameters (mm, arcsec, steradians) and shapes. 
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtapertures
;
; COMMON BLOCK PARAMETERS
;         P_MM : PHT-P aperture dimensions in mm
;	  P_AS : PHT-P aperture dimensions in arcseconds
;	  P_SR : PHT-P aperture dimensions in steradians
;         P_Shape : PHT-P aperture shapes
;
;	  C1_MM : PHT-C100 (square) pixel size in mm
;	  C1_AS : PHT-C100 (square) pixel size in arcseconds
;	  C1_SR : PHT-C100 (square) pixel size in steradians
;
;	  C2_MM : PHT-C200 (square) pixel size in mm
;	  C2_AS : PHT-C200 (square) pixel size in arcseconds
;	  C2_SR : PHT-C200 (square) pixel size in steradians 
;
; MODIFICATION HISTORY:
; 	Written by: Huw Morris (DRAL), February 1995
;	Oct 95 Version 3.5
;			
;-

	COMMON PHTApertures, P_MM, P_AS, P_SR, P_Shape, C1_MM, C1_AS, $
               C1_SR, C2_MM, C2_AS, C2_SR
