;+
; NAME:
;	PHTBCKDEF
; PURPOSE:
;	This is not an IDL routine as such, but contains the definition of the
;	common block PHTBCKDEF for inclusion into other routines. By defining
;       the common block in one place, the problem of conflicting definitions
;       is avoided. It contains, also, the values of the default backgrond 
;       which can be considered in order to perform the point source extraction. 
;
;	This file is included into routines that need this common block and the 
;       value default background with the single line (left justified)
;
;				  @phtbckdef
;
;
;
;	This file  contains the following variables:
;
;	EXP_H_X : The default expected value of h_x as defined in PIA_SM_PSEX
;       EXP_H_Y : The default expected value of h_y as defined in PIA_SM_PSEX
;       EXP_H_C : The default expected value of h_c as defined in PIA_SM_PSEX
;       DEF_SIGMA_H_X: The standard variation of h_x as defined in PIA_SM_PSEX
;       DEF_SIGMA_H_Y: The standard variation of h_y as defined in PIA_SM_PSEX 
;       DEF_SIGMA_H_C: The standard variation of h_c as defined in PIA_SM_PSEX 
;       FACTOR = The factor which indicates haw many times the quantities H 
;                should be greater than the EXP_H
;
; MODIFICATION HISTORY:
;	Paola Merluzzi                          August 1995
;-

	COMMON PHTBCKDEF, exp_h_x, exp_h_y, exp_h_c, $
                    def_sigma_h_x, def_sigma_h_y, def_sigma_h_c, factor

        n_axis = 3
        exp_h = fltarr(n_axis)
        def_sigma_h = fltarr(n_axis)
        exp_h(0) = 0.
        exp_h(1) = 0.                          
        exp_h(2) = 0.
        def_sigma_h(0) = 1e-16
        def_sigma_h(1) = 1e-16
        def_sigma_h(2) = 1e-16
        factor = 1.

;        RETURN
;        END
