;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;	PHTILLUM
;
; PURPOSE:
;	Definition of the common block PHTILLUM (Fine Clibration Soure
;	Illumination matrices) for inclusion into other routines.  
;
; CATEGORY:
;       PIA - common block
;
; CALLING SEQUENCE:
;	@phtillum
;
; COMMON BLOCK PARAMETERS:
;	This file stores the FCS illumination matrices 
;
;	PHTILLUM contains the following variables:
;
;	C1ILCOR : The C100 FCS illumination matrices
;	C1ILLUN : Uncertainties of C1ILCOR
;	C2ILCOR : The C200 FCS illumination matrices
;	C2ILLUN : Uncertainties of C2ILCOR
;
;
; MODIFICATION HISTORY:
;	Written by: Carlos GABRIEL, ESA/ESTEC 		November 1994
;	Oct 95 Version 3.5
;			
;-

	COMMON PHTILLUM, C1ILCOR, C1ILLUN, C2ILCOR, C2ILLUN
