;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;+
; NAME:
;       PhtSrd_init
; PURPOSE:
;       Initializes the structure PHTSRD (Signal Data) defining the
;	contents as a template structure PHTSRD_TYPE. It can be used
;	for clearing the whole SRD structure, in case this should 
;	show as necessary. 
;
; CATEGORY:
;       PIA - initialization
;
; CALLING SEQUENCE:
;       @phtsrd_init
;
; COMMON BLOCKS:
;	phtsrd
;
; MODIFICATION HISTORY:
;       Written by: C. Gabriel (ESA/ESTEC)             		July 1994
;	Modified (last) by CG 					September 1994
;	Oct 95 Version 3.5
;	Extension: effective reset time and read-outs used (CG)	January 1996
;			
;-
;
@phtsrd
        ON_ERROR, 2
;
	PHTSRD_REC = {PHTSRD_TYPE, UNIT: ' ', $
	DET: ' ',	$
	ADMN: ' ',	$
        ORDR: 0, 	$
        DIMS: 0L,	$ 
        SLDI: 0L, 	$
        RCHP: 0L, 	$
	HDR: HANDLE_CREATE(),	$
        SLOP: HANDLE_CREATE(), $
	SLUN: HANDLE_CREATE(), $
	FLAG: HANDLE_CREATE(), $
	STIM: HANDLE_CREATE(), $
	CHOP: HANDLE_CREATE(), $
	STEP: HANDLE_CREATE(), $
	FCSN: HANDLE_CREATE(), $
	TEMP: HANDLE_CREATE(), $
	FCS1: HANDLE_CREATE(), $
	FCS2: HANDLE_CREATE(), $
        TKEY: HANDLE_CREATE(), $
        RPID: HANDLE_CREATE(), $
        RESI: HANDLE_CREATE(), $
	NROS: HANDLE_CREATE()}
; the first_handle is the index of the first handle in the
; structure and the last_handle is the index of the last
; handle, it is mainly used for clear the buffer. Define
; here would eliminate the need to change the srd_init
; for releasing the handle.
	SRD_FIRST_HANDLE = 7
	SRD_LAST_HANDLE = 21
        PHTSRD_DESC = [ $
                'Acquisition date',                     $
                'Detector',                             $
                'Internal Name ',                       $
                'Order within TDT ',                    $
                'Dimensions    ',                       $
		'Extra Dimensions',			$
                'Ramps / Chopper Pl',                   $
                'Header',                               $
                'Ramp slopes      ',                    $
                'Ramp slopes uncertainty',		$
                'Flag           ',                      $
                'Time within Measurement',		$
                'Chopper position',                     $
                'Chopper step     ',                    $
                'FCS number       ',                    $
                'Temperature    ',                      $
                'FCS1 electrical power ',               $
                'FCS2 electrical power ',               $
                'Instrument time key    ',              $
                'Raster point ID        ',              $
                'Effective reset time   ',              $
                'Nr. of read-outs used  '               $
        ]
	PHTSRD = {PHTSRD_TYPE}
