	PRO FXBCLOSE, UNIT
;+
; Project     : SOHO - CDS
;
; Name        : 
;	FXBCLOSE
; Purpose     : 
;	Close a FITS binary table extension opened for read.
; Explanation : 
;	Closes a FITS binary table extension that had been opened for read by
;	FXBOPEN.
; Use         : 
;	FXBCLOSE, UNIT
; Inputs      : 
;	UNIT	= Logical unit number of the file.
; Opt. Inputs : 
;	None.
; Outputs     : 
;	None.
; Opt. Outputs: 
;	None.
; Keywords    : 
;	None.
; Calls       : 
;	None.
; Common      : 
;	Uses common block FXBINTABLE--see "fxbintable.pro" for more
;	information.
; Restrictions: 
;	The file must have been opened with FXBOPEN.
; Side effects: 
;	None.
; Category    : 
;	Data Handling, I/O, FITS, Generic.
; Prev. Hist. : 
;	W. Thompson, Feb. 1992.
; Written     : 
;	William Thompson, GSFC, February 1992.
; Modified    : 
;	Version 1, William Thompson, GSFC, 12 April 1993.
;		Incorporated into CDS library.
; Version     : 
;	Version 1, 12 April 1993.
;-
;
@fxbintable
	ON_ERROR, 2
;
;  Check the number of parameters.
;
	IF N_PARAMS() NE 1 THEN MESSAGE, 'Syntax:  FXBCLOSE, UNIT'
;
;  Find the index of the file.
;
	ILUN = WHERE(LUN EQ UNIT,NLUN)
	ILUN = ILUN(0)
	IF NLUN EQ 0 THEN MESSAGE,'Unit ' + STRTRIM(UNIT,2) +	$
		' not opened properly'
;
;  Make sure the file was opened for read access.
;
	IF STATE(ILUN) NE 1 THEN MESSAGE,'Unit ' + STRTRIM(UNIT,2) +	$
		' not opened for read access'
;
;  Close the file, and mark it as closed.
;
	FREE_LUN,UNIT
	STATE(ILUN) = 0
;
	RETURN
	END
