;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!                                                                             !
;! This routine belongs to the PHT Interactive Analysis Package PIA.           !
;!                                                                             !
;! PIA is a joint development by the ESA Astrophysics Division and the ISOPHOT !
;! Consortium led by the Max Planck Institute for Astronomy (MPIA), Heidelberg.! 
;! Contributing ISOPHOT Consortium institutes are DIAS, RAL, AIP, MPIK, and    !
;! MPIA.                                                                       !
;!                                                                             ! 
;! Its use and distribution are free, as long as this header text is not       !
;! removed, or changed. When publishing ISOPHOT Data reduced with this analysis!
;! package, please mention this in the acknowledgement.                        !
;!                                                                             !
;! No warranties for installation/ support/ maintenance are given.             ! 
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        PRO PIA_STRUCTURES_HELP, erd=erd, srd=srd, scp=scp, $
        	spd=spd, aap=aap 
;+
; NAME:
;       PIA_STRUCTURES_HELP
;
; PURPOSE:
;	Print information on the dynamical PIA buffers 
;
; CATEGORY:
;	PIA - help
;
; CALLING SEQUENCE:
;       pia_structures_help, [/phterd], [/phtsrd], ...
;
; INPUT KEYWORDS:
;	phterd: To obtain info on phterd
;	phtsrd: To obtain info on phtsrd
;	phtscp: To obtain info on phtscp
;	phtspd: To obtain info on phtspd
;	phtaap: To obtain info on phtaap
;
;
; PROCEDURES USED: 
;       Common Block(s) or @ procedure(s):
;               phterd
;               phtsrd
;               phtscp
;               phtspd
;               phtaap
;
; MODIFICATION HISTORY:
;       Written by: C. Gabriel  (ESA-SAI)		July 1996
;
;-
;
@phterd
@phtsrd
@phtscp
@phtspd
@phtaap
;
	IF KEYWORD_SET(erd) THEN BEGIN
		PRINT, 'PHTERD structure:'
		PRINT, '-----------------'
		PRINT, ' '
		tt = tag_names(phterd)
		for i=0,N_Tags(phterd) - 1 DO PRINT, tt(i)+': '+phterd_desc(i)
		PRINT, ' '
	ENDIF
	IF KEYWORD_SET(srd) THEN BEGIN
		PRINT, 'PHTsrd structure:'
		PRINT, '-----------------'
		PRINT, ' '
		tt = tag_names(phtsrd)
		for i=0,N_Tags(phtsrd) - 1 DO PRINT, tt(i)+': '+phtsrd_desc(i)
		PRINT, ' '
	ENDIF
	IF KEYWORD_SET(scp) THEN BEGIN
		PRINT, 'PHTscp structure:'
		PRINT, '-----------------'
		PRINT, ' '
		tt = tag_names(phtscp)
		for i=0,N_Tags(phtscp) - 1 DO PRINT, tt(i)+': '+phtscp_desc(i)
		PRINT, ' '
	ENDIF
	IF KEYWORD_SET(spd) THEN BEGIN
		PRINT, 'PHTspd structure:'
		PRINT, '-----------------'
		PRINT, ' '
		tt = tag_names(phtspd)
		for i=0,N_Tags(phtspd) - 1 DO PRINT, tt(i)+': '+phtspd_desc(i)
		PRINT, ' '
	ENDIF
	IF KEYWORD_SET(aap) THEN BEGIN
		PRINT, 'PHTaap structure:'
		PRINT, '-----------------'
		PRINT, ' '
		tt = tag_names(phtaap)
		for i=0,N_Tags(phtaap) - 1 DO PRINT, tt(i)+': '+phtaap_desc(i)
		PRINT, ' '
	ENDIF
	 

        RETURN
        END
