FUNCTION REPCHR, OLD, C1, C2, help=hlp
;+
; NAME: 
;	REPCHR
; PURPOSE: 
;	Replace all occurences of one character with another
;	in a text string.   (Use the procedure REPSTR to replace
;	more than one character.)
;
; CALLING SEQUENCE: 
;   new = repchr( old, c1, [c2] )      
;
; INPUTS:
;	OLD = text string to edit, scalar or vector
;	C1 = character to replace.
;
; OPTIONAL INPUTS:
;	C2 = character to insert (def = ' ' = space).
;
; OUTPUTS:
;	NEW = edited string.
;
; EXAMPLE:
;	If old = 'THIS_IS_THE_TEXT' and  c1 = '_' then
;
;	IDL> print, repchr( old,c1 ) 
;
;	would display   'THIS IS THE TEXT'
;
; MODIFICATION HISTORY: 
;   R. Sterner.  28 Oct, 1986.
;   Removed call to ARRAY function,   W. Landsman    December, 1991
;-
	if (N_params() LT 2) or keyword_set(HELP) then begin
	  print,' Replace all occurrences of one character with another '+$
	    'in a text string.'
	  print,' new = repchr(old, c1, [c2])'
	  print,'   old = original text string.          in'
	  print,'   c1 = character to replace.           in'
	  print,'   c2 = character to replace it with.   in'
	  print,'        default is space.'
	  print,'   new = edited string.                 out'
	  return, -1
endif

 b = byte(old)  		     ; convert string to a byte array.
 cb1 = byte(c1)	   		     ; convert char 1 to byte.
 w = where( b EQ cb1(0), Nfound)     ; find occurrences of char 1.
 if Nfound EQ 0 then return, old     ; if none, return old string.
 if N_params() LT 3 then c2 = ' '    ; default char 2 is space.
 cb2 = byte(c2)			     ; convert char 2 to byte.
 b(w) = cb2(0)	  		     ; replace char 1 by char 2.
 return, string(b)   		     ; return new string.
 end  
